/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.statistics;

import com.tangosol.internal.net.metrics.Meter;
import com.tangosol.internal.net.topic.impl.paged.management.PolledMetrics;
import com.tangosol.internal.net.topic.impl.paged.model.PagedPosition;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.util.Base;
import java.util.Objects;

public class SubscriberGroupChannelStatistics
implements PolledMetrics {
    private final int f_nChannel;
    private final Meter f_metricPolled = new Meter();
    private PagedPosition m_head = PagedPosition.NULL_POSITION;
    private SubscriberId m_owningSubscriber;
    private PagedPosition m_committedPosition;
    private long m_lastCommittedTimestamp;
    private long m_lastPolledTimestamp;

    public SubscriberGroupChannelStatistics(int nChannel) {
        this.f_nChannel = nChannel;
    }

    public int getChannel() {
        return this.f_nChannel;
    }

    @Override
    public long getPolledCount() {
        return this.f_metricPolled.getCount();
    }

    @Override
    public double getPolledFifteenMinuteRate() {
        return this.f_metricPolled.getFifteenMinuteRate();
    }

    @Override
    public double getPolledFiveMinuteRate() {
        return this.f_metricPolled.getFiveMinuteRate();
    }

    @Override
    public double getPolledOneMinuteRate() {
        return this.f_metricPolled.getOneMinuteRate();
    }

    @Override
    public double getPolledMeanRate() {
        return this.f_metricPolled.getMeanRate();
    }

    public void onPolled(long cMessage, PagedPosition head) {
        this.f_metricPolled.mark(cMessage);
        this.setHead(head);
    }

    public PagedPosition getHead() {
        return this.m_head;
    }

    public void setHead(PagedPosition head) {
        if (Objects.requireNonNull(head).compareTo(this.m_head) > 0) {
            this.m_head = head;
            this.m_lastPolledTimestamp = Base.getSafeTimeMillis();
        }
    }

    public SubscriberId getOwningSubscriber() {
        return this.m_owningSubscriber;
    }

    public void setOwningSubscriber(SubscriberId nOwningSubscriber) {
        this.m_owningSubscriber = nOwningSubscriber;
    }

    public void onCommitted(PagedPosition committedPosition) {
        this.m_committedPosition = committedPosition;
        this.m_lastCommittedTimestamp = Base.getSafeTimeMillis();
    }

    public PagedPosition getLastCommittedPosition() {
        return this.m_committedPosition;
    }

    public long getLastCommittedTimestamp() {
        return this.m_lastCommittedTimestamp;
    }

    public long getLastPolledTimestamp() {
        return this.m_lastPolledTimestamp;
    }
}

