/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.statistics;

import com.tangosol.internal.net.metrics.Meter;
import com.tangosol.internal.net.topic.impl.paged.management.PublishedMetrics;
import com.tangosol.internal.net.topic.impl.paged.model.PagedPosition;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.statistics.PagedTopicChannelStatistics;
import com.tangosol.internal.net.topic.impl.paged.statistics.SubscriberGroupStatistics;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapListener;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SimpleLongArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PagedTopicStatistics
implements PublishedMetrics {
    private final String m_sTopicName;
    private final LongArray<PagedTopicChannelStatistics> m_aChannelStats = new SimpleLongArray();
    private final Meter f_metricPublished = new Meter();
    private final ObservableMap<SubscriberGroupId, SubscriberGroupStatistics> f_mapSubscriberGroups = new ObservableHashMap<SubscriberGroupId, SubscriberGroupStatistics>();
    private final Lock f_lock = new ReentrantLock(true);

    public PagedTopicStatistics(int cChannel, String sTopicName) {
        this.m_sTopicName = sTopicName;
        for (int i = 0; i < cChannel; ++i) {
            this.m_aChannelStats.set(i, new PagedTopicChannelStatistics(i));
        }
    }

    public String getTopicName() {
        return this.m_sTopicName;
    }

    public PagedTopicChannelStatistics getChannelStatistics(int nChannel) {
        PagedTopicChannelStatistics statistics = this.m_aChannelStats.get(nChannel);
        if (statistics == null) {
            this.f_lock.lock();
            try {
                statistics = new PagedTopicChannelStatistics(nChannel);
                this.m_aChannelStats.set(nChannel, statistics);
            }
            finally {
                this.f_lock.unlock();
            }
        }
        return statistics;
    }

    public void onPublished(int nChannel, long cMessage, PagedPosition tail) {
        this.f_metricPublished.mark(cMessage);
        this.getChannelStatistics(nChannel).onPublished(cMessage, tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriberGroupStatistics getSubscriberGroupStatistics(SubscriberGroupId id) {
        SubscriberGroupStatistics statistics = (SubscriberGroupStatistics)this.f_mapSubscriberGroups.get(id);
        if (statistics == null) {
            this.f_lock.lock();
            try {
                int cChannel = (int)this.m_aChannelStats.getLastIndex();
                statistics = this.f_mapSubscriberGroups.computeIfAbsent(id, s -> new SubscriberGroupStatistics(cChannel));
            }
            finally {
                this.f_lock.unlock();
            }
        }
        return statistics;
    }

    public void removeSubscriberGroupStatistics(SubscriberGroupId id) {
        this.f_lock.lock();
        try {
            this.f_mapSubscriberGroups.remove(id.getGroupName());
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public void addSubscriberGroupListener(MapListener<SubscriberGroupId, SubscriberGroupStatistics> listener) {
        this.f_mapSubscriberGroups.addMapListener(listener);
    }

    public void removeSubscriberGroupListener(MapListener<SubscriberGroupId, SubscriberGroupStatistics> listener) {
        this.f_mapSubscriberGroups.removeMapListener(listener);
    }

    @Override
    public long getPublishedCount() {
        return this.f_metricPublished.getCount();
    }

    @Override
    public double getPublishedFifteenMinuteRate() {
        return this.f_metricPublished.getFifteenMinuteRate();
    }

    @Override
    public double getPublishedFiveMinuteRate() {
        return this.f_metricPublished.getFiveMinuteRate();
    }

    @Override
    public double getPublishedOneMinuteRate() {
        return this.f_metricPublished.getOneMinuteRate();
    }

    @Override
    public double getPublishedMeanRate() {
        return this.f_metricPublished.getMeanRate();
    }
}

