/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.statistics;

import com.tangosol.internal.net.metrics.Meter;
import com.tangosol.internal.net.topic.impl.paged.management.PublishedMetrics;
import com.tangosol.internal.net.topic.impl.paged.model.PagedPosition;
import java.util.Objects;

public class PagedTopicChannelStatistics
implements PublishedMetrics {
    private final int f_nChannel;
    private final Meter f_metricPublished = new Meter();
    private PagedPosition m_tail = PagedPosition.NULL_POSITION;

    public PagedTopicChannelStatistics(int nChannel) {
        this.f_nChannel = nChannel;
    }

    public int getChannel() {
        return this.f_nChannel;
    }

    @Override
    public long getPublishedCount() {
        return this.f_metricPublished.getCount();
    }

    @Override
    public double getPublishedFifteenMinuteRate() {
        return this.f_metricPublished.getFifteenMinuteRate();
    }

    @Override
    public double getPublishedFiveMinuteRate() {
        return this.f_metricPublished.getFiveMinuteRate();
    }

    @Override
    public double getPublishedOneMinuteRate() {
        return this.f_metricPublished.getOneMinuteRate();
    }

    @Override
    public double getPublishedMeanRate() {
        return this.f_metricPublished.getMeanRate();
    }

    public void onPublished(long cMessage, PagedPosition tail) {
        this.f_metricPublished.mark(cMessage);
        this.setTail(tail);
    }

    public PagedPosition getTail() {
        return this.m_tail;
    }

    public void setTail(PagedPosition tail) {
        if (Objects.requireNonNull(tail).compareTo(this.m_tail) > 0) {
            this.m_tail = tail;
        }
    }
}

