/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.model;

import com.tangosol.internal.net.topic.SimpleChannelAllocationStrategy;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicSubscriber;
import com.tangosol.internal.net.topic.impl.paged.model.PagedPosition;
import com.tangosol.internal.net.topic.impl.paged.model.PagedTopicSubscription;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.Member;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.util.Filter;
import com.tangosol.util.HashHelper;
import com.tangosol.util.ValueExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Subscription
extends AbstractEvolvable
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 4;
    private long m_lHeadSubscription = -1L;
    private long m_lPage = -1L;
    private int m_nPosition;
    private PagedPosition m_posCommitted = PagedPosition.NULL_POSITION;
    private PagedPosition m_posRollback = PagedPosition.NULL_POSITION;
    private Filter<?> m_filter;
    private Function<?, ?> m_fnConvert;
    private SubscriberId m_owningSubscriber;
    private SubscriberId m_lastPolledSubscriber;
    private SortedMap<Long, SubscriberId> m_mapSubscriber;
    private long[] m_aChannel;
    private int m_cChannel;
    private final transient Lock f_lock = new ReentrantLock();

    public Subscription() {
    }

    public Subscription(int cChannel) {
        this.m_cChannel = cChannel;
    }

    public long getSubscriptionHead() {
        return this.m_lHeadSubscription;
    }

    public void setSubscriptionHead(long lPage) {
        this.m_lHeadSubscription = lPage;
    }

    public long getPage() {
        return this.m_lPage;
    }

    public void setPage(long lPage) {
        this.m_lPage = lPage;
    }

    public int getPosition() {
        return this.m_nPosition;
    }

    public void setPosition(int nPosition) {
        this.m_nPosition = nPosition;
    }

    public PagedPosition getHeadPosition() {
        return new PagedPosition(this.m_lPage, this.m_nPosition);
    }

    public void setCommittedPosition(PagedPosition posCommit, PagedPosition posRollback) {
        this.m_posCommitted = posCommit;
        this.m_posRollback = posRollback;
    }

    public PagedPosition getCommittedPosition() {
        return this.m_posCommitted;
    }

    public PagedPosition getRollbackPosition() {
        return this.m_posRollback;
    }

    public Filter<?> getFilter() {
        return this.m_filter;
    }

    public void setFilter(Filter<?> filter) {
        this.m_filter = filter;
    }

    public Function<?, ?> getConverter() {
        return this.m_fnConvert;
    }

    public void setConverter(Function<?, ?> fnConvert) {
        this.m_fnConvert = fnConvert;
    }

    public SubscriberId getLastPolledSubscriber() {
        return this.m_lastPolledSubscriber;
    }

    public void setLastPolledSubscriber(SubscriberId id) {
        this.m_lastPolledSubscriber = id;
    }

    public SubscriberId getOwningSubscriber() {
        return this.m_owningSubscriber;
    }

    public void setOwningSubscriber(SubscriberId nOwningSubscriber) {
        if (!Objects.equals(this.m_owningSubscriber, nOwningSubscriber)) {
            this.m_owningSubscriber = nOwningSubscriber;
            this.rollback();
        }
    }

    public void rollback() {
        this.m_lPage = this.m_posRollback.getPage();
        this.m_nPosition = this.m_posRollback.getOffset();
    }

    public int getLatestChannelCount() {
        return this.m_cChannel;
    }

    public SubscriberId getChannelOwner(int nChannel) {
        if (this.m_aChannel == null) {
            return this.m_owningSubscriber;
        }
        if (nChannel < this.m_aChannel.length) {
            long nId = this.m_aChannel[nChannel];
            return (SubscriberId)this.m_mapSubscriber.get(nId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Set<SubscriberId>> addSubscriber(SubscriberId subscriberId, int cChannel, Set<Member> setMember) {
        if (subscriberId == null || subscriberId.getId() == 0L) {
            return Collections.emptyMap();
        }
        this.f_lock.lock();
        try {
            SubscriberId idPrevious;
            if (this.m_mapSubscriber == null) {
                this.m_mapSubscriber = new TreeMap<Long, SubscriberId>();
            }
            if ((idPrevious = this.m_mapSubscriber.putIfAbsent(subscriberId.getId(), subscriberId)) == null || cChannel != this.m_cChannel) {
                Map<Integer, Set<SubscriberId>> map = this.refresh(this.m_mapSubscriber, cChannel, setMember);
                return map;
            }
            Map<Integer, Set<SubscriberId>> map = Collections.emptyMap();
            return map;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Set<SubscriberId>> removeSubscriber(SubscriberId subscriberId, int cChannel, Set<Member> setMember) {
        if (subscriberId == null || subscriberId.getId() == 0L) {
            return Collections.emptyMap();
        }
        this.f_lock.lock();
        try {
            if (this.m_mapSubscriber != null) {
                if (this.m_mapSubscriber.remove(subscriberId.getId()) != null) {
                    Map<Integer, Set<SubscriberId>> mapRemoved = this.refresh(this.m_mapSubscriber, cChannel, setMember);
                    int nMember = this.m_owningSubscriber.getMemberId();
                    mapRemoved.compute(nMember, (key, set) -> this.ensureSet(nMember, subscriberId, (Set<SubscriberId>)set));
                    Map<Integer, Set<SubscriberId>> map = mapRemoved;
                    return map;
                }
            } else if (Objects.equals(this.m_owningSubscriber, subscriberId)) {
                int nMember = subscriberId.getMemberId();
                this.m_owningSubscriber = null;
                Map<Integer, Set<SubscriberId>> map = Collections.singletonMap(nMember, Collections.singleton(subscriberId));
                return map;
            }
            Map<Integer, Set<SubscriberId>> map = Collections.emptyMap();
            return map;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Set<SubscriberId>> removeAllSubscribers(int cChannel, Set<Member> setMember) {
        this.f_lock.lock();
        try {
            if (this.m_mapSubscriber != null) {
                this.m_mapSubscriber.clear();
                Map<Integer, Set<SubscriberId>> map = this.refresh(this.m_mapSubscriber, cChannel, setMember);
                return map;
            }
            if (this.m_owningSubscriber != null) {
                SubscriberId subscriberId = this.m_owningSubscriber;
                int nMember = this.m_owningSubscriber.getMemberId();
                this.m_owningSubscriber = null;
                Map<Integer, Set<SubscriberId>> map = Collections.singletonMap(nMember, Collections.singleton(subscriberId));
                return map;
            }
            Map<Integer, Set<SubscriberId>> map = Collections.emptyMap();
            return map;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public Set<SubscriberId> getSubscribers() {
        return this.m_mapSubscriber == null ? Collections.emptySet() : new TreeSet<SubscriberId>(this.m_mapSubscriber.values());
    }

    public boolean hasSubscriber(SubscriberId id) {
        return this.m_mapSubscriber == null ? Objects.equals(this.m_owningSubscriber, id) : this.m_mapSubscriber.containsKey(id.getId());
    }

    public String getAllocations() {
        Map<Long, Set<Integer>> map = this.getAllocationMap();
        if (map.isEmpty()) {
            return "[all channels unallocated]";
        }
        return map.entrySet().stream().map(e -> String.valueOf(e.getValue()) + "=" + String.valueOf(e.getKey()) + "/" + PagedTopicSubscriber.memberIdFromId((Long)e.getKey())).collect(Collectors.joining(", "));
    }

    public Map<Long, Set<Integer>> getAllocationMap() {
        HashMap<Long, Set<Integer>> map = new HashMap<Long, Set<Integer>>();
        long[] alChannel = this.m_aChannel;
        for (int i = 0; i < alChannel.length; ++i) {
            if (alChannel[i] == 0L) continue;
            map.computeIfAbsent(alChannel[i], k -> new TreeSet()).add(i);
        }
        return map;
    }

    public int[] getChannels(long nSubscriber, int cChannel) {
        return this.getChannels((SubscriberId)this.m_mapSubscriber.get(nSubscriber), cChannel);
    }

    public int[] getChannels(SubscriberId subscriberId, int cChannel) {
        if (subscriberId == null) {
            return new int[0];
        }
        if (this.m_aChannel == null || this.m_aChannel.length == 0) {
            if (Objects.equals(subscriberId, this.m_owningSubscriber)) {
                int[] anChannel = new int[cChannel];
                for (int i = 0; i < cChannel; ++i) {
                    anChannel[i] = i;
                }
                return anChannel;
            }
            return new int[0];
        }
        long nSubscriber = subscriberId.getId();
        int cMatch = (int)Arrays.stream(this.m_aChannel).filter(s -> s == nSubscriber).count();
        int[] anChannel = new int[cMatch];
        int nIndex = 0;
        for (int i = 0; i < this.m_aChannel.length; ++i) {
            if (this.m_aChannel[i] != nSubscriber) continue;
            anChannel[nIndex++] = i;
        }
        return anChannel;
    }

    long[] getChannelAllocations() {
        return this.m_aChannel;
    }

    public Subscription update(PagedTopicSubscription subscription) {
        if (subscription != null) {
            this.f_lock.lock();
            try {
                if (this.m_mapSubscriber == null) {
                    this.m_mapSubscriber = new TreeMap<Long, SubscriberId>();
                }
                subscription.addSubscribersTo(this.m_mapSubscriber);
                long[] alChannel = subscription.getChannelAllocations();
                if (this.m_aChannel == null || this.m_aChannel.length != alChannel.length) {
                    this.m_aChannel = new long[alChannel.length];
                }
                System.arraycopy(alChannel, 0, this.m_aChannel, 0, alChannel.length);
                this.m_cChannel = this.m_aChannel.length;
            }
            finally {
                this.f_lock.unlock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignAll(SubscriberId subscriberId, int cChannel, Set<Member> setMember) {
        this.f_lock.lock();
        try {
            if (this.m_mapSubscriber == null) {
                this.m_mapSubscriber = new TreeMap<Long, SubscriberId>();
            }
            long nId = subscriberId.getId();
            long[] alChannel = new long[cChannel];
            Arrays.fill(alChannel, nId);
            this.m_mapSubscriber.clear();
            this.m_mapSubscriber.put(nId, subscriberId);
            this.m_aChannel = alChannel;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public static Key createSyncKey(SubscriberGroupId subscriberGroupId, int nChannel, int cParts) {
        int nPart = Subscription.getSyncPartition(subscriberGroupId, nChannel, cParts);
        return new Key(nPart, nChannel, subscriberGroupId);
    }

    public static int getSyncPartition(SubscriberGroupId subscriberGroupId, int nChannel, int cParts) {
        return Math.abs(HashHelper.hash(subscriberGroupId.hashCode(), nChannel) % cParts);
    }

    @Override
    public int getImplVersion() {
        return 4;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_lHeadSubscription = in.readLong(0);
        this.m_lPage = in.readLong(1);
        this.m_nPosition = in.readInt(2);
        this.m_filter = (Filter)in.readObject(3);
        this.m_fnConvert = (Function)in.readObject(4);
        List listSubscriber = new ArrayList();
        int nVersion = this.getDataVersion();
        long nId = 0L;
        if (nVersion >= 2) {
            nId = in.readLong(5);
            listSubscriber = in.readCollection(6, listSubscriber);
            this.m_aChannel = in.readLongArray(7);
            this.m_posCommitted = (PagedPosition)in.readObject(8);
            this.m_posRollback = (PagedPosition)in.readObject(9);
        }
        if (nVersion >= 3) {
            this.m_owningSubscriber = (SubscriberId)in.readObject(10);
            this.m_mapSubscriber = in.readMap(11, new TreeMap());
        } else {
            this.m_owningSubscriber = nId == 0L ? null : new SubscriberId(nId, null);
            this.m_mapSubscriber = new TreeMap<Long, SubscriberId>();
            for (Long n : listSubscriber) {
                this.m_mapSubscriber.put(n, new SubscriberId(n, null));
            }
        }
        if (nVersion >= 4) {
            this.m_cChannel = in.readInt(12);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_lHeadSubscription);
        out.writeLong(1, this.m_lPage);
        out.writeInt(2, this.m_nPosition);
        out.writeObject(3, this.m_filter);
        out.writeObject(4, this.m_fnConvert);
        long nId = this.m_owningSubscriber == null ? 0L : this.m_owningSubscriber.getId();
        out.writeLong(5, nId);
        Set<Long> setKey = this.m_mapSubscriber == null ? null : this.m_mapSubscriber.keySet();
        out.writeCollection(6, setKey);
        out.writeLongArray(7, this.m_aChannel);
        out.writeObject(8, this.m_posCommitted);
        out.writeObject(9, this.m_posRollback);
        out.writeObject(10, this.m_owningSubscriber);
        out.writeMap(11, this.m_mapSubscriber);
        out.writeInt(12, this.m_cChannel);
        out.writeObject(13, this.m_lastPolledSubscriber);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(head=" + this.m_lHeadSubscription + ", page=" + this.m_lPage + ", position=" + this.m_nPosition + ", committed=" + String.valueOf(this.m_posCommitted.getPage() == -1L ? "None" : this.m_posCommitted) + ", rollback=" + String.valueOf(this.m_posRollback.getPage() == -1L ? "Unset" : this.m_posRollback) + ", filter=" + String.valueOf(this.m_filter) + ", converter=" + String.valueOf(this.m_fnConvert) + ", owner=" + String.valueOf(this.m_owningSubscriber) + ", lastPolledBy=" + String.valueOf(this.m_lastPolledSubscriber) + ", subscribers=" + String.valueOf(this.m_mapSubscriber) + ", channelOwners=" + Arrays.toString(this.m_aChannel) + ")";
    }

    private Map<Integer, Set<SubscriberId>> refresh(SortedMap<Long, SubscriberId> mapSubscriber, int cChannel, Set<Member> setMember) {
        SimpleChannelAllocationStrategy strategy = new SimpleChannelAllocationStrategy();
        SortedMap<Integer, Set<SubscriberId>> mapRemoved = strategy.cleanup(mapSubscriber, setMember);
        this.m_aChannel = strategy.allocate(mapSubscriber, cChannel);
        this.m_cChannel = cChannel;
        return mapRemoved;
    }

    private Set<SubscriberId> ensureSet(Integer ignored, SubscriberId id, Set<SubscriberId> setId) {
        if (setId == null) {
            setId = new HashSet<SubscriberId>();
        }
        setId.add(id);
        return setId;
    }

    public static class Key
    implements KeyPartitioningStrategy.PartitionAwareKey,
    PortableObject,
    Comparable<Key> {
        private int m_nPartition;
        private int m_nChannel;
        private SubscriberGroupId m_groupId;

        public Key() {
        }

        public Key(int nPartition, int nChannel, SubscriberGroupId groupId) {
            this.m_nPartition = nPartition;
            this.m_nChannel = nChannel;
            this.m_groupId = groupId;
        }

        public SubscriberGroupId getGroupId() {
            return this.m_groupId;
        }

        public int getChannelId() {
            return this.m_nChannel;
        }

        @Override
        public int compareTo(Key other) {
            int i = this.m_groupId.compareTo(other.m_groupId);
            if (i == 0) {
                i = Integer.compare(this.m_nChannel, other.m_nChannel);
            }
            if (i == 0) {
                i = Integer.compare(this.m_nPartition, other.m_nPartition);
            }
            return i;
        }

        @Override
        public int getPartitionId() {
            return this.m_nPartition;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_nPartition = in.readInt(0);
            this.m_nChannel = in.readInt(1);
            this.m_groupId = (SubscriberGroupId)in.readObject(2);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeInt(0, this.m_nPartition);
            out.writeInt(1, this.m_nChannel);
            out.writeObject(2, this.m_groupId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return this.m_nPartition == that.m_nPartition && this.m_nChannel == that.m_nChannel && Objects.equals(this.m_groupId, that.m_groupId);
        }

        public int hashCode() {
            int hash = HashHelper.hash(this.m_nPartition, this.m_nChannel);
            return HashHelper.hash(this.m_groupId, hash);
        }

        public String toString() {
            return "SubscriberPartitionKey(Partition=" + this.m_nPartition + ", channel=" + this.m_nChannel + ", subscriberGroup='" + String.valueOf(this.m_groupId) + "')";
        }
    }

    public static class HeadExtractor
    implements ValueExtractor<Subscription, PagedPosition>,
    PortableObject {
        private long m_nSubscriberId;

        public HeadExtractor() {
        }

        public HeadExtractor(long nSubscriberId) {
            this.m_nSubscriberId = nSubscriberId;
        }

        @Override
        public PagedPosition extract(Subscription subscription) {
            PagedPosition position;
            if (subscription.getOwningSubscriber().getId() == this.m_nSubscriberId) {
                position = subscription.getHeadPosition();
            } else {
                position = subscription.getRollbackPosition();
                if (position.getPage() == -1L) {
                    position = subscription.getHeadPosition();
                }
            }
            if (position.getOffset() == Integer.MAX_VALUE && position.getPage() != -1L) {
                position = new PagedPosition(position.getPage() + 1L, 0);
            }
            return position.getPage() == -1L ? null : position;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_nSubscriberId = in.readLong(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeLong(0, this.m_nSubscriberId);
        }
    }
}

