/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.model;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicSubscriber;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.UUID;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.EntryExtractor;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;

public class SubscriberInfo
extends AbstractEvolvable
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 3;
    private long m_lConnectionTimestamp;
    private LocalDateTime m_dtLastHeartbeat;
    private long m_cTimeoutMillis;
    private UUID m_owningUid;
    private long m_lSubscriptionId;

    public LocalDateTime getLastHeartbeat() {
        return this.m_dtLastHeartbeat;
    }

    public void setLastHeartbeat(LocalDateTime timestamp) {
        this.m_dtLastHeartbeat = timestamp;
    }

    public long getTimeoutMillis() {
        return this.m_cTimeoutMillis;
    }

    public void setTimeoutMillis(long cTimeoutMillis) {
        this.m_cTimeoutMillis = cTimeoutMillis;
    }

    public UUID getOwningUid() {
        return this.m_owningUid;
    }

    public void setOwningUid(UUID uuid) {
        this.m_owningUid = uuid;
    }

    public long getSubscriptionId() {
        return this.m_lSubscriptionId;
    }

    public void setSubscriptionId(long lSubscriptionId) {
        this.m_lSubscriptionId = lSubscriptionId;
    }

    public long getConnectionTimestamp() {
        return this.m_lConnectionTimestamp;
    }

    public void setlConnectionTimestamp(long lTimestamp) {
        this.m_lConnectionTimestamp = lTimestamp;
    }

    @Override
    public int getImplVersion() {
        return 3;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        int nVersion = in.getVersionId();
        this.m_dtLastHeartbeat = in.readLocalDateTime(0);
        this.m_cTimeoutMillis = in.readLong(1);
        if (nVersion >= 2) {
            this.m_owningUid = (UUID)in.readObject(2);
        }
        if (nVersion >= 3) {
            this.m_lSubscriptionId = in.readLong(3);
            this.m_lConnectionTimestamp = in.readLong(4);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeDateTime(0, this.m_dtLastHeartbeat);
        out.writeLong(1, this.m_cTimeoutMillis);
        out.writeObject(2, this.m_owningUid);
        out.writeLong(3, this.m_lSubscriptionId);
        out.writeLong(4, this.m_lConnectionTimestamp);
    }

    public String toString() {
        return "SubscriberInfo(lastHeartbeat=" + String.valueOf(this.m_dtLastHeartbeat) + "uid=" + String.valueOf(this.m_owningUid) + "subscription=" + this.m_lSubscriptionId + "connectedTime=" + this.m_lConnectionTimestamp + ")";
    }

    public static class MemberIdExtractor
    extends EntryExtractor
    implements PortableObject {
        public static ValueExtractor<Map.Entry<Key, SubscriberInfo>, Integer> INSTANCE = new MemberIdExtractor();

        public Object extractFromEntry(Map.Entry entry) {
            return PagedTopicSubscriber.memberIdFromId(((Key)entry.getKey()).m_subscriberId);
        }
    }

    public static class GroupIdExtractor
    extends EntryExtractor
    implements PortableObject {
        public static ValueExtractor<Map.Entry<Key, SubscriberInfo>, SubscriberGroupId> INSTANCE = new GroupIdExtractor();

        public Object extractFromEntry(Map.Entry entry) {
            return ((Key)entry.getKey()).m_groupId;
        }
    }

    public static class Key
    implements PortableObject {
        private SubscriberGroupId m_groupId;
        private long m_subscriberId;

        public Key() {
        }

        public Key(SubscriberGroupId groupId, long subscriberId) {
            this.m_groupId = groupId;
            this.m_subscriberId = subscriberId;
        }

        public SubscriberGroupId getGroupId() {
            return this.m_groupId;
        }

        public long getSubscriberId() {
            return this.m_subscriberId;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_groupId = (SubscriberGroupId)in.readObject(0);
            this.m_subscriberId = in.readLong(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_groupId);
            out.writeLong(1, this.m_subscriberId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.m_subscriberId == key.m_subscriberId && Objects.equals(this.m_groupId, key.m_groupId);
        }

        public int hashCode() {
            return Objects.hash(this.m_groupId, this.m_subscriberId);
        }

        public String toString() {
            return "SubscriberInfo.Key(groupId=" + String.valueOf(this.m_groupId) + ", subscriberId=" + this.m_subscriberId + ", memberId=" + PagedTopicSubscriber.memberIdFromId(this.m_subscriberId) + ")";
        }
    }
}

