/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.model;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicSubscriber;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.UUID;
import com.tangosol.util.comparator.SafeComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public class SubscriberId
implements Subscriber.Id,
Comparable<SubscriberId>,
PortableObject,
ExternalizableLite {
    public static final SubscriberId NullSubscriber = new SubscriberId();
    private int m_nNotificationId;
    private int m_nMemberId;
    private UUID m_uuid;
    private long m_nId;

    public SubscriberId() {
        this(0L, null);
    }

    public SubscriberId(long nId, UUID uuid) {
        this.m_nNotificationId = PagedTopicSubscriber.notificationIdFromId(nId);
        this.m_nMemberId = PagedTopicSubscriber.memberIdFromId(nId);
        this.m_uuid = uuid;
        this.m_nId = nId;
    }

    public SubscriberId(int nNotificationId, int nMemberId, UUID uuid) {
        this.m_nNotificationId = nNotificationId;
        this.m_nMemberId = nMemberId;
        this.m_uuid = uuid;
        this.m_nId = PagedTopicSubscriber.createId(this.m_nNotificationId, this.m_nMemberId);
    }

    public int getNotificationId() {
        return this.m_nNotificationId;
    }

    public int getMemberId() {
        return this.m_nMemberId;
    }

    public UUID getUID() {
        return this.m_uuid;
    }

    public long getId() {
        return this.m_nId;
    }

    @Override
    public int compareTo(SubscriberId other) {
        int n = Long.compare(this.m_nId, other.m_nId);
        if (n == 0) {
            n = SafeComparator.compareSafe(null, this.m_uuid, other.m_uuid);
        }
        return n;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nNotificationId = in.readInt();
        this.m_nMemberId = in.readInt();
        this.m_uuid = (UUID)ExternalizableHelper.readObject(in);
        this.m_nId = in.readLong();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_nNotificationId);
        out.writeInt(this.m_nMemberId);
        ExternalizableHelper.writeObject(out, this.m_uuid);
        out.writeLong(this.m_nId);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nNotificationId = in.readInt(0);
        this.m_nMemberId = in.readInt(1);
        this.m_uuid = (UUID)in.readObject(2);
        this.m_nId = in.readLong(3);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nNotificationId);
        out.writeInt(1, this.m_nMemberId);
        out.writeObject(2, this.m_uuid);
        out.writeLong(3, this.m_nId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriberId that = (SubscriberId)o;
        return this.m_nNotificationId == that.m_nNotificationId && this.m_nMemberId == that.m_nMemberId && Objects.equals(this.m_uuid, that.m_uuid);
    }

    public int hashCode() {
        return Objects.hash(this.m_nNotificationId, this.m_nMemberId, this.m_uuid);
    }

    public String toString() {
        return "SubscriberId{notificationId=" + this.m_nNotificationId + ", memberId=" + this.m_nMemberId + ", uid=" + String.valueOf(this.m_uuid) + ", id=" + this.m_nId + "}";
    }

    public static void main(String[] args) {
        for (String s : args) {
            long nId = Long.parseLong(s);
            System.out.println(PagedTopicSubscriber.notificationIdFromId(nId) + " " + PagedTopicSubscriber.memberIdFromId(nId));
        }
    }
}

