/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.model;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Member;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.HashHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class SubscriberGroupId
implements ExternalizableLite,
PortableObject,
Comparable<SubscriberGroupId> {
    private String m_sGroupId;
    private long m_ldtMember;
    private static final AtomicLong s_counter = new AtomicLong();

    public SubscriberGroupId() {
    }

    public SubscriberGroupId(String sName) {
        this.m_sGroupId = Objects.requireNonNull(sName, "Subscriber group name cannot be null");
        this.m_ldtMember = 0L;
    }

    public SubscriberGroupId(Member member) {
        this.m_sGroupId = String.valueOf(s_counter.incrementAndGet());
        this.m_ldtMember = member.getTimestamp();
    }

    public String getGroupName() {
        return this.m_sGroupId;
    }

    public long getMemberTimestamp() {
        return this.m_ldtMember;
    }

    public boolean isAnonymous() {
        return this.m_ldtMember != 0L;
    }

    public boolean isDurable() {
        return !this.isAnonymous();
    }

    @Override
    public int compareTo(SubscriberGroupId other) {
        if (other == null) {
            return 1;
        }
        int i = this.m_sGroupId.compareTo(other.m_sGroupId);
        if (i == 0) {
            i = Long.compare(this.m_ldtMember, other.m_ldtMember);
        }
        return i;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sGroupId = ExternalizableHelper.readSafeUTF(in);
        this.m_ldtMember = in.readLong();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF(out, this.m_sGroupId);
        out.writeLong(this.m_ldtMember);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sGroupId = in.readString(0);
        this.m_ldtMember = in.readLong(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sGroupId);
        out.writeLong(1, this.m_ldtMember);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriberGroupId that = (SubscriberGroupId)o;
        return this.m_ldtMember == that.m_ldtMember && Base.equals(this.m_sGroupId, that.m_sGroupId);
    }

    public int hashCode() {
        return HashHelper.hash(this.m_ldtMember, this.m_sGroupId.hashCode());
    }

    public String toString() {
        long lTimestamp = this.m_ldtMember;
        return this.getClass().getSimpleName() + "(" + (String)(lTimestamp == 0L ? "" : lTimestamp + "/") + this.m_sGroupId + ")";
    }

    public static SubscriberGroupId withName(String sName) {
        return new SubscriberGroupId(sName);
    }

    public static SubscriberGroupId anonymous() {
        return new SubscriberGroupId(CacheFactory.getCluster().getLocalMember());
    }
}

