/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.model;

import com.oracle.coherence.common.util.SafeClock;
import com.tangosol.internal.fastutil.ints.IntSortedSets;
import com.tangosol.internal.net.topic.ChannelAllocationStrategy;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.net.topic.TopicException;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.UUID;
import com.tangosol.util.ValueExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PagedTopicSubscription
implements ExternalizableLite {
    private static final long[] EMPTY = new long[0];
    public static final SortedSet<Integer> NO_CHANNELS = IntSortedSets.EMPTY_SET;
    private static final SafeClock s_clock = SafeClock.INSTANCE;
    private final Lock f_lock = new ReentrantLock();
    private Key m_key;
    private long m_nSubscriptionId;
    private Filter<?> m_filter;
    private ValueExtractor<?, ?> m_extractor;
    private final SortedMap<Long, SubscriberId> m_mapSubscriber = new TreeMap<Long, SubscriberId>();
    private long[] m_aChannelAllocation = EMPTY;
    private final Map<SubscriberId, Object> m_mapSubscriberChannels = new HashMap<SubscriberId, Object>();
    private final Map<Long, Long> m_mapSubscriberTimestamp = new HashMap<Long, Long>();

    public PagedTopicSubscription() {
    }

    public PagedTopicSubscription(PagedTopicSubscription subscription) {
        this.m_key = subscription.m_key;
        this.m_nSubscriptionId = subscription.m_nSubscriptionId;
        this.m_filter = subscription.m_filter;
        this.m_extractor = subscription.m_extractor;
        this.update(subscription);
    }

    public String getTopicName() {
        return this.m_key == null ? null : this.m_key.getTopicName();
    }

    public SubscriberGroupId getGroupId() {
        return this.m_key == null ? null : this.m_key.getGroupId();
    }

    public SubscriberGroupId getSubscriberGroupId() {
        return this.m_key == null ? null : this.m_key.getGroupId();
    }

    public void setKey(String sTopicName, SubscriberGroupId groupId) {
        this.setKey(new Key(sTopicName, groupId));
    }

    public Key getKey() {
        return this.m_key;
    }

    public void setKey(Key key) {
        this.m_key = key;
    }

    public long getSubscriptionId() {
        return this.m_nSubscriptionId;
    }

    public void setSubscriptionId(long lId) {
        this.m_nSubscriptionId = lId;
    }

    public void update(PagedTopicSubscription subscription) {
        this.f_lock.lock();
        try {
            this.m_aChannelAllocation = Arrays.copyOf(subscription.m_aChannelAllocation, subscription.m_aChannelAllocation.length);
            this.m_mapSubscriber.keySet().retainAll(subscription.m_mapSubscriber.keySet());
            this.m_mapSubscriber.putAll(subscription.m_mapSubscriber);
            this.m_mapSubscriberChannels.keySet().retainAll(subscription.m_mapSubscriberChannels.keySet());
            this.m_mapSubscriberChannels.putAll(subscription.m_mapSubscriberChannels);
            this.m_mapSubscriberTimestamp.keySet().retainAll(subscription.m_mapSubscriberTimestamp.keySet());
            this.m_mapSubscriberTimestamp.putAll(subscription.m_mapSubscriberTimestamp);
        }
        finally {
            this.f_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubscribers(SubscriberId ... aSubscriberId) {
        if (aSubscriberId.length == 0) {
            return false;
        }
        boolean fModified = false;
        this.f_lock.lock();
        try {
            for (SubscriberId subscriberId : aSubscriberId) {
                boolean fAdded;
                if (SubscriberId.NullSubscriber.equals(subscriberId)) continue;
                boolean bl = fAdded = this.m_mapSubscriber.putIfAbsent(subscriberId.getId(), subscriberId) == null;
                if (!fAdded) continue;
                fModified = true;
                this.m_mapSubscriberTimestamp.put(subscriberId.getId(), s_clock.getSafeTimeMillis());
            }
        }
        finally {
            this.f_lock.unlock();
        }
        return fModified;
    }

    public boolean hasSubscriber(SubscriberId subscriberId) {
        return SubscriberId.NullSubscriber.equals(subscriberId) || this.m_mapSubscriber.containsKey(subscriberId.getId());
    }

    public long getSubscriberTimestamp(SubscriberId id) {
        long nId = id.getId();
        if (nId == 0L) {
            return 0L;
        }
        Long lTimestamp = this.m_mapSubscriberTimestamp.get(nId);
        return lTimestamp == null ? Long.MAX_VALUE : lTimestamp;
    }

    public Set<SubscriberId> getSubscriberIds() {
        this.f_lock.lock();
        try {
            HashSet<SubscriberId> hashSet = new HashSet<SubscriberId>(this.m_mapSubscriber.values());
            return hashSet;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public void addSubscribersTo(Map<Long, SubscriberId> map) {
        this.f_lock.lock();
        try {
            map.putAll(this.m_mapSubscriber);
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public boolean removeAllSubscribers() {
        this.f_lock.lock();
        try {
            if (this.m_mapSubscriber.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.m_mapSubscriber.clear();
            Arrays.fill(this.m_aChannelAllocation, 0L);
            this.m_mapSubscriberChannels.clear();
            this.m_mapSubscriberTimestamp.clear();
            boolean bl = true;
            return bl;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSubscribers(SubscriberId ... aSubscriberId) {
        if (aSubscriberId.length == 0) {
            return false;
        }
        this.f_lock.lock();
        try {
            boolean fModified = false;
            for (SubscriberId subscriberId : aSubscriberId) {
                if (subscriberId == null) continue;
                fModified = this.m_mapSubscriber.remove(subscriberId.getId()) != null || fModified;
                this.m_mapSubscriberTimestamp.remove(subscriberId.getId());
                this.m_mapSubscriberChannels.remove(subscriberId);
            }
            boolean bl = fModified;
            return bl;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public int getChannelCount() {
        return this.m_aChannelAllocation == null ? 0 : this.m_aChannelAllocation.length;
    }

    public SubscriberId getOwningSubscriber(int nChannel) {
        long[] aChannelAllocation = this.m_aChannelAllocation;
        if (aChannelAllocation.length > nChannel) {
            long lId = aChannelAllocation[nChannel];
            return (SubscriberId)this.m_mapSubscriber.get(lId);
        }
        return null;
    }

    public long[] getChannelAllocations() {
        this.f_lock.lock();
        try {
            long[] anCopy = new long[this.m_aChannelAllocation.length];
            System.arraycopy(this.m_aChannelAllocation, 0, anCopy, 0, this.m_aChannelAllocation.length);
            long[] lArray = anCopy;
            return lArray;
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public SortedSet<Integer> getOwnedChannels(SubscriberId id) {
        Object oValue;
        if (id == null) {
            return NO_CHANNELS;
        }
        this.f_lock.lock();
        try {
            oValue = this.m_mapSubscriberChannels.get(id);
        }
        finally {
            this.f_lock.unlock();
        }
        if (oValue == null) {
            return NO_CHANNELS;
        }
        if (oValue instanceof Integer) {
            return IntSortedSets.singleton((Integer)oValue);
        }
        return Collections.unmodifiableSortedSet((SortedSet)oValue);
    }

    public void updateChannelAllocations(ChannelAllocationStrategy strategy) {
        this.updateChannelAllocations(strategy, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChannelAllocations(ChannelAllocationStrategy strategy, int cChannel) {
        this.f_lock.lock();
        try {
            if (cChannel <= 0) {
                cChannel = this.m_aChannelAllocation.length;
            }
            this.m_aChannelAllocation = strategy.allocate(this.m_mapSubscriber, cChannel);
            this.m_mapSubscriberChannels.clear();
            for (int i = 0; i < this.m_aChannelAllocation.length; ++i) {
                int nChannel = i;
                SubscriberId subscriberId = this.m_mapSubscriber.getOrDefault(this.m_aChannelAllocation[i], SubscriberId.NullSubscriber);
                this.m_mapSubscriberChannels.compute(subscriberId, (k, oValue) -> {
                    if (oValue == null) {
                        return nChannel;
                    }
                    if (oValue instanceof Integer) {
                        Integer n = (Integer)((Object)oValue);
                        oValue = new TreeSet<Integer>();
                        oValue.add(n);
                    }
                    ((TreeSet)oValue).add(nChannel);
                    return oValue;
                });
            }
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public Filter<?> getFilter() {
        return this.m_filter;
    }

    public void setFilter(Filter<?> filter) {
        this.m_filter = filter;
    }

    public ValueExtractor<?, ?> getConverter() {
        return this.m_extractor;
    }

    public void setConverter(ValueExtractor<?, ?> extractor) {
        this.m_extractor = extractor;
    }

    public boolean isAnonymous() {
        return this.m_key.getGroupId().isAnonymous();
    }

    public void assertFilterAndConverter(Filter<?> filter, ValueExtractor<?, ?> extractor) {
        if (filter != null && !Objects.equals(filter, this.m_filter)) {
            throw new TopicException("Cannot change the Filter in existing Subscriber group \"" + this.m_key.getGroupName() + "\" current=" + String.valueOf(this.m_filter) + " new=" + String.valueOf(filter));
        }
        if (extractor != null && !Objects.equals(this.m_extractor, extractor)) {
            throw new TopicException("Cannot change the converter function in existing Subscriber group \"" + this.m_key.getGroupName() + "\" current=" + String.valueOf(this.m_extractor) + " new=" + String.valueOf(extractor));
        }
    }

    public Set<SubscriberId> getDepartedSubscribers(Set<UUID> setMember) {
        HashSet<SubscriberId> setDeparted = new HashSet<SubscriberId>();
        for (SubscriberId id : this.m_mapSubscriber.values()) {
            if (setMember.contains(id.getUID())) continue;
            setDeparted.add(id);
        }
        return setDeparted;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.f_lock.lock();
        try {
            this.m_key = (Key)ExternalizableHelper.readObject(in);
            this.m_nSubscriptionId = in.readLong();
            this.m_filter = (Filter)ExternalizableHelper.readObject(in);
            this.m_extractor = (ValueExtractor)ExternalizableHelper.readObject(in);
            this.m_aChannelAllocation = (long[])ExternalizableHelper.readObject(in);
            this.m_mapSubscriber.clear();
            ExternalizableHelper.readMap(in, this.m_mapSubscriber, null);
            this.m_mapSubscriberChannels.clear();
            ExternalizableHelper.readMap(in, this.m_mapSubscriberChannels, null);
            this.m_mapSubscriberTimestamp.clear();
            ExternalizableHelper.readMap(in, this.m_mapSubscriberTimestamp, null);
        }
        finally {
            this.f_lock.unlock();
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        this.f_lock.lock();
        try {
            ExternalizableHelper.writeObject(out, this.m_key);
            out.writeLong(this.m_nSubscriptionId);
            ExternalizableHelper.writeObject(out, this.m_filter);
            ExternalizableHelper.writeObject(out, this.m_extractor);
            ExternalizableHelper.writeObject(out, this.m_aChannelAllocation);
            ExternalizableHelper.writeMap(out, this.m_mapSubscriber);
            ExternalizableHelper.writeMap(out, this.m_mapSubscriberChannels);
            ExternalizableHelper.writeMap(out, this.m_mapSubscriberTimestamp);
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public String toString() {
        return "PagedTopicSubscription{key=" + String.valueOf(this.m_key) + " subscriptionId=" + this.m_nSubscriptionId + ", filter=" + String.valueOf(this.m_filter) + ", extractor=" + String.valueOf(this.m_extractor) + ", subscribers=" + String.valueOf(this.m_mapSubscriber) + ", channelAllocations=" + Arrays.toString(this.m_aChannelAllocation) + ", subscriberAllocations=" + String.valueOf(this.m_mapSubscriberChannels) + ", timestamps=" + String.valueOf(this.m_mapSubscriberTimestamp) + "}";
    }

    public static class Key
    implements ExternalizableLite {
        public String m_sTopicName;
        public SubscriberGroupId m_groupId;

        public Key() {
        }

        public Key(String sTopicName, SubscriberGroupId groupId) {
            this.m_sTopicName = sTopicName;
            this.m_groupId = groupId;
        }

        public String getTopicName() {
            return this.m_sTopicName;
        }

        public SubscriberGroupId getGroupId() {
            return this.m_groupId;
        }

        public String getGroupName() {
            return this.m_groupId.getGroupName();
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_sTopicName = ExternalizableHelper.readSafeUTF(in);
            this.m_groupId = (SubscriberGroupId)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeSafeUTF(out, this.m_sTopicName);
            ExternalizableHelper.writeObject(out, this.m_groupId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.m_sTopicName, key.m_sTopicName) && Objects.equals(this.m_groupId, key.m_groupId);
        }

        public int hashCode() {
            return Objects.hash(this.m_sTopicName, this.m_groupId);
        }

        public String toString() {
            return "PagedTopicSubscription.Key{topic='" + this.m_sTopicName + "', group='" + String.valueOf(this.m_groupId) + "'}";
        }
    }

    public static interface Listener {
        public void onUpdate(PagedTopicSubscription var1);

        public void onDelete(PagedTopicSubscription var1);
    }
}

