/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.model;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.topic.Position;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public class PagedPosition
implements Position,
PortableObject,
ExternalizableLite {
    public static final PagedPosition NULL_POSITION = new PagedPosition(-1L, Integer.MAX_VALUE);
    public static final int NULL_OFFSET = -1;
    private long m_nPage;
    private int m_nOffset;

    public PagedPosition() {
        this(-1L, -1);
    }

    public PagedPosition(long nPage, int nOffset) {
        this.m_nPage = nPage;
        this.m_nOffset = nOffset;
    }

    public long getPage() {
        return this.m_nPage;
    }

    public int getOffset() {
        return this.m_nOffset;
    }

    public void setOffset(int nOffset) {
        this.m_nOffset = nOffset;
    }

    public PagedPosition next() {
        if (this.m_nPage == -1L) {
            return this;
        }
        if (this.m_nOffset == Integer.MAX_VALUE) {
            return new PagedPosition(this.m_nPage + 1L, 0);
        }
        return new PagedPosition(this.m_nPage, this.m_nOffset + 1);
    }

    @Override
    public int compareTo(Position other) {
        int nResult = -1;
        if (other instanceof PagedPosition && (nResult = Long.compare(this.m_nPage, ((PagedPosition)other).m_nPage)) == 0) {
            nResult = Integer.compare(this.m_nOffset, ((PagedPosition)other).m_nOffset);
        }
        return nResult;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nPage = in.readLong();
        this.m_nOffset = in.readInt();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeLong(this.m_nPage);
        out.writeInt(this.m_nOffset);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nPage = in.readLong(0);
        this.m_nOffset = in.readInt(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_nPage);
        out.writeInt(1, this.m_nOffset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagedPosition that = (PagedPosition)o;
        return this.m_nPage == that.m_nPage && this.m_nOffset == that.m_nOffset;
    }

    public int hashCode() {
        return Objects.hash(this.m_nPage, this.m_nOffset);
    }

    public String toString() {
        if (this.m_nPage == -1L && this.m_nOffset == -1) {
            return "PagedPosition(None)";
        }
        return "PagedPosition(page=" + this.m_nPage + ", offset=" + this.m_nOffset + ")";
    }
}

