/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.model;

import com.oracle.coherence.common.base.Converter;
import com.tangosol.internal.net.topic.impl.paged.model.PagedPosition;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerAware;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.topic.Position;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class PageElement<V>
implements Subscriber.Element<V>,
PortableObject,
ExternalizableLite,
SerializerAware {
    private final int DECO_RSVD_1 = 6;
    private ReadBuffer m_binValue;
    private Converter<Binary, V> m_converter;
    private transient Serializer m_serializer;
    private ReadBuffer m_binUndecorated;
    private ReadBuffer m_binMetadata;
    private V m_oValue;
    private int m_nChannel;
    private PagedPosition m_position;
    private long m_lTimestamp;

    public PageElement() {
    }

    PageElement(Binary binary, Serializer serializer) {
        this(binary, (Binary b) -> ExternalizableHelper.fromBinary(b, serializer));
        this.m_serializer = serializer;
    }

    PageElement(Binary binary, Converter<Binary, V> converter) {
        this.m_binValue = binary;
        this.m_converter = converter;
    }

    @Override
    public V getValue() {
        if (this.m_oValue == null) {
            this.m_oValue = this.m_converter.convert(this.m_binValue.toBinary());
        }
        return this.m_oValue;
    }

    @Override
    public Binary getBinaryValue() {
        if (this.m_binUndecorated == null) {
            this.m_binUndecorated = ExternalizableHelper.undecorate(this.m_binValue, 6);
        }
        return this.m_binUndecorated.toBinary();
    }

    @Override
    public int getChannel() {
        this.ensureMetadata();
        return this.m_nChannel;
    }

    @Override
    public Position getPosition() {
        this.ensureMetadata();
        return this.m_position;
    }

    @Override
    public Instant getTimestamp() {
        this.ensureMetadata();
        return Instant.ofEpochMilli(this.m_lTimestamp);
    }

    @Override
    public CompletableFuture<Subscriber.CommitResult> commitAsync() {
        throw new UnsupportedOperationException();
    }

    public long getTimestampMillis() {
        this.ensureMetadata();
        return this.m_lTimestamp;
    }

    @Override
    public Serializer getContextSerializer() {
        return this.m_serializer;
    }

    @Override
    public void setContextSerializer(Serializer serializer) {
        this.m_serializer = serializer;
        this.m_converter = b -> ExternalizableHelper.fromBinary(b, serializer);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_binValue = (ReadBuffer)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_binValue);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_binValue = in.readBinary(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBinary(0, this.m_binValue.toBinary());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageElement element = (PageElement)o;
        return Objects.equals(this.m_binValue, element.m_binValue);
    }

    public int hashCode() {
        return Objects.hash(this.m_binValue);
    }

    public String toString() {
        return "Element(channel=" + this.getChannel() + ", position=" + String.valueOf(this.getPosition()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    public static Binary toBinary(int nChannel, long lPage, int nOffset, long lTimestamp, Binary binValue) {
        byte[] ab = new byte[30];
        int cb = 0;
        cb += PageElement.pack(nChannel, ab, cb);
        cb += PageElement.pack(lPage, ab, cb);
        cb += PageElement.pack(nOffset, ab, cb);
        cb += PageElement.pack(lTimestamp, ab, cb);
        Binary binMetadata = new Binary(ab, 0, cb);
        return ExternalizableHelper.decorate(binValue, 6, binMetadata);
    }

    public static <V> PageElement<V> fromBinary(Binary binary, Serializer serializer) {
        return new PageElement<V>(binary, serializer);
    }

    public static <V> PageElement<V> fromBinary(Binary binary, Converter<Binary, V> converter) {
        return new PageElement<V>(binary, converter);
    }

    public <U> Binary convert(Function<V, U> fn, Converter<U, Binary> serializer) {
        this.ensureMetadata();
        U oConverted = fn.apply(this.getValue());
        if (oConverted != null) {
            Binary binValue = serializer.convert(oConverted);
            return ExternalizableHelper.decorate((ReadBuffer)binValue, 6, this.m_binMetadata).toBinary();
        }
        return null;
    }

    private void ensureMetadata() {
        try {
            if (this.m_binMetadata == null) {
                ReadBuffer binDeco = ExternalizableHelper.getDecoration(this.m_binValue, 6);
                ReadBuffer.BufferInput in = binDeco.getBufferInput();
                int nChannel = in.readPackedInt();
                long lPage = in.readPackedLong();
                int nOffset = in.readPackedInt();
                long lTimestamp = in.readPackedLong();
                this.m_nChannel = nChannel;
                this.m_position = new PagedPosition(lPage, nOffset);
                this.m_lTimestamp = lTimestamp;
                this.m_binMetadata = binDeco;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static int pack(long l, byte[] ab, int of) {
        int cb = 0;
        int b = 0;
        if (l < 0L) {
            b = 64;
            l ^= 0xFFFFFFFFFFFFFFFFL;
        }
        b |= (byte)((int)l & 0x3F);
        l >>>= 6;
        while (l != 0L) {
            ab[of + cb++] = (byte)(b |= 0x80);
            b = (int)l & 0x7F;
            l >>>= 7;
        }
        ab[of + cb++] = (byte)b;
        return cb;
    }
}

