/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.model;

import com.tangosol.internal.net.topic.impl.paged.model.Page;
import com.tangosol.io.ReadBuffer;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.HashHelper;
import java.io.IOException;

public class ContentKey
implements KeyPartitioningStrategy.PartitionAwareKey {
    private final int m_nChannel;
    private final long m_lPage;
    private final int m_nElement;

    public ContentKey(int nChannel, long lPage, int nElement) {
        this.m_nChannel = nChannel;
        this.m_lPage = lPage;
        this.m_nElement = nElement;
    }

    public int getChannel() {
        return this.m_nChannel;
    }

    public long getPage() {
        return this.m_lPage;
    }

    public int getElement() {
        return this.m_nElement;
    }

    @Override
    public int getPartitionId() {
        return Page.Key.mapPageToPartition(this.m_nChannel, this.m_lPage);
    }

    public Binary toBinary(int cPartitions) {
        return ContentKey.toBinary(this.getPartitionId() % cPartitions, this.getChannel(), this.getPage(), this.getElement());
    }

    public static Binary toBinary(int nPartition, int nChannel, long lPage, int nElement) {
        byte[] ab = new byte[26];
        int cb = 0;
        ab[cb++] = 13;
        cb += ContentKey.pack(nPartition, ab, cb);
        cb += ContentKey.pack(nChannel, ab, cb);
        cb += ContentKey.pack(lPage, ab, cb);
        cb += ContentKey.pack(nElement, ab, cb);
        return new Binary(ab, 0, cb);
    }

    public static ContentKey fromBinary(Binary bin) {
        return ContentKey.fromBinary(bin, false);
    }

    public static ContentKey fromBinary(Binary bin, boolean fDecorated) {
        try {
            ReadBuffer.BufferInput in = bin.getBufferInput();
            if (fDecorated) {
                byte bDeco = in.readByte();
                int n = in.readPackedInt();
            }
            int nChannel = in.readPackedInt();
            long lPage = in.readPackedLong();
            int nElement = in.readPackedInt();
            return new ContentKey(nChannel, lPage, nElement);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static int pack(long l, byte[] ab, int of) {
        int cb = 0;
        int b = 0;
        if (l < 0L) {
            b = 64;
            l ^= 0xFFFFFFFFFFFFFFFFL;
        }
        b |= (byte)((int)l & 0x3F);
        l >>>= 6;
        while (l != 0L) {
            ab[of + cb++] = (byte)(b |= 0x80);
            b = (int)l & 0x7F;
            l >>>= 7;
        }
        ab[of + cb++] = (byte)b;
        return cb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentKey key = (ContentKey)o;
        return this.m_nChannel == key.m_nChannel && this.m_lPage == key.m_lPage && this.m_nElement == key.m_nElement;
    }

    public int hashCode() {
        int hash = HashHelper.hash(this.m_lPage, 31);
        return HashHelper.hash(this.m_nElement, hash);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(channel=" + this.m_nChannel + ", page=" + this.m_lPage + ", element=" + this.m_nElement + ")";
    }

    private static class DecoHelper
    extends ExternalizableHelper {
        static final byte FMT_IDO = 13;

        private DecoHelper() {
        }
    }
}

