/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.management;

import com.oracle.coherence.common.base.Exceptions;
import com.tangosol.internal.net.management.model.AbstractModel;
import com.tangosol.internal.net.management.model.ModelAttribute;
import com.tangosol.internal.net.management.model.ModelOperation;
import com.tangosol.internal.net.management.model.SimpleModelAttribute;
import com.tangosol.internal.net.management.model.SimpleModelOperation;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicSubscriber;
import com.tangosol.internal.net.topic.impl.paged.management.ChannelCountsTableModel;
import com.tangosol.internal.net.topic.impl.paged.management.ChannelPositionTableModel;
import com.tangosol.internal.net.topic.impl.paged.management.SubscriberChannelTableModel;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.net.Cluster;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Position;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import java.util.Arrays;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;

public class SubscriberModel
extends AbstractModel<SubscriberModel>
implements DynamicMBean {
    protected static final String MBEAN_DESCRIPTION = "A Coherence PagedTopic Subscriber.";
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_CHANNEL_COUNT = SimpleModelAttribute.intBuilder("ChannelCount", SubscriberModel.class).withDescription("The number of channels in the topic.").withFunction(SubscriberModel::getChannelCount).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_ID = SimpleModelAttribute.longBuilder("Id", SubscriberModel.class).withDescription("The subscriber's identifier.").withFunction(SubscriberModel::getId).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_NOTIFICATION_ID = SimpleModelAttribute.longBuilder("NotificationId", SubscriberModel.class).withDescription("The subscriber's notification identifier.").withFunction(SubscriberModel::getNotificationId).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_TYPE = SimpleModelAttribute.stringBuilder("Type", SubscriberModel.class).withDescription("The type of this subscriber.").withFunction(SubscriberModel::getSubscriberType).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_CHANNEL_ALLOCATIONS = SimpleModelAttribute.stringBuilder("ChannelAllocations", SubscriberModel.class).withDescription("The subscriber's allocated channels.").withFunction(SubscriberModel::getChannels).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_SUBSCRIBER_GROUP = SimpleModelAttribute.stringBuilder("SubscriberGroup", SubscriberModel.class).withDescription("The subscriber group the subscriber belongs to.").withFunction(SubscriberModel::getSubscriberGroup).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_POLLS = SimpleModelAttribute.longBuilder("Polls", SubscriberModel.class).withDescription("The total number of polls for messages.").withFunction(SubscriberModel::getPolls).metric(true).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_SUB_TYPE_CODE = SimpleModelAttribute.longBuilder("SubTypeCode", SubscriberModel.class).withDescription("Indicates if the subscriber is Durable (1) or Anonymous (0).").withFunction(SubscriberModel::getSubTypeCode).metric(true).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_ELEMENTS = SimpleModelAttribute.longBuilder("ReceivedCount", SubscriberModel.class).withDescription("The number of elements received.").withFunction(SubscriberModel::getElementsPolled).metric(true).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_RECEIVE_CANCELLED = SimpleModelAttribute.longBuilder("CancelledCount", SubscriberModel.class).withDescription("The number of cancelled receive requests.").withFunction(SubscriberModel::getCancelledCount).metric("CancelledCount").build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_RECEIVE_QUEUE = SimpleModelAttribute.longBuilder("ReceiveBacklog", SubscriberModel.class).withDescription("The number of outstanding receive requests.").withFunction(SubscriberModel::getReceiveQueueSize).metric("ReceiveBacklog").build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_RECEIVE_REQUESTS = SimpleModelAttribute.longBuilder("ReceiveRequestCount", SubscriberModel.class).withDescription("The number of calls to one of the receive methods.").withFunction(SubscriberModel::getReceiveCalls).metric("ReceiveRequestCount").build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_RECEIVE_COMPLETIONS = SimpleModelAttribute.longBuilder("ReceiveCompletionsCount", SubscriberModel.class).withDescription("The number completed receive requests.").withFunction(SubscriberModel::getReceivedCount).metric("ReceiveCompletionsCount").build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_RECEIVE_COMPLETIONS_MEAN = SimpleModelAttribute.doubleBuilder("ReceiveCompletionsMeanRate", SubscriberModel.class).withDescription("The completed receive requests, mean rate.").withFunction(SubscriberModel::getReceivedMeanRate).metric("ReceiveCompletions").withMetricLabels("rate", "mean").build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_RECEIVE_COMPLETIONS_ONE = SimpleModelAttribute.doubleBuilder("ReceiveCompletionsOneMinuteRate", SubscriberModel.class).withDescription("The completed receive requests, one-minute rate.").withFunction(SubscriberModel::getReceivedOneMinuteRate).metric("ReceiveCompletions").withMetricLabels("rate", "1-min").build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_RECEIVE_COMPLETIONS_FIVE = SimpleModelAttribute.doubleBuilder("ReceiveCompletionsFiveMinuteRate", SubscriberModel.class).withDescription("The completed receive requests, five-minute rate.").withFunction(SubscriberModel::getReceivedFiveMinuteRate).metric("ReceiveCompletions").withMetricLabels("rate", "5-min").build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_RECEIVE_COMPLETIONS_FIFTEEN = SimpleModelAttribute.doubleBuilder("ReceiveCompletionsFifteenMinuteRate", SubscriberModel.class).withDescription("The completed receive requests, fifteen-minute rate.").withFunction(SubscriberModel::getReceivedFifteenMinuteRate).metric("ReceiveCompletions").withMetricLabels("rate", "15-min").build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_RECEIVE_ERRORS = SimpleModelAttribute.longBuilder("ReceiveErrors", SubscriberModel.class).withDescription("The number exceptionally completed receive requests.").withFunction(SubscriberModel::getErrorCount).metric(true).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_RECEIVE_EMPTY = SimpleModelAttribute.longBuilder("ReceiveEmpty", SubscriberModel.class).withDescription("The number empty receive requests.").withFunction(SubscriberModel::getReceivedEmptyCount).metric(true).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_WAITS = SimpleModelAttribute.longBuilder("Waits", SubscriberModel.class).withDescription("The number of waits on an empty channel.").withFunction(SubscriberModel::getWaits).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_NOTIFICATIONS = SimpleModelAttribute.longBuilder("Notifications", SubscriberModel.class).withDescription("The number of channel notifications received.").withFunction(SubscriberModel::getNotifications).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_STATE = SimpleModelAttribute.longBuilder("State", SubscriberModel.class).withDescription("The state of the subscriber.").withFunction(SubscriberModel::getState).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_STATE_NAME = SimpleModelAttribute.stringBuilder("StateName", SubscriberModel.class).withDescription("The state of the subscriber as a string.").withFunction(SubscriberModel::getStateName).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_BACKLOG = SimpleModelAttribute.longBuilder("Backlog", SubscriberModel.class).withDescription("The number of outstanding receive requests.").withFunction(SubscriberModel::getBacklog).metric(true).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_MAX_BACKLOG = SimpleModelAttribute.longBuilder("MaxBacklog", SubscriberModel.class).withDescription("The maximum number of outstanding receive requests allowed before flow control blocks receive calls.").withFunction(SubscriberModel::getMaxBacklog).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_DISCONNECTIONS = SimpleModelAttribute.longBuilder("Disconnections", SubscriberModel.class).withDescription("The number of times this subscriber has disconnected.").withFunction(SubscriberModel::getDisconnectCount).metric(true).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_FILTER = SimpleModelAttribute.stringBuilder("Filter", SubscriberModel.class).withDescription("The optional filter being used to filter messages.").withFunction(SubscriberModel::getFilter).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_CONVERTER = SimpleModelAttribute.stringBuilder("Converter", SubscriberModel.class).withDescription("The optional converter being used to transform messages.").withFunction(SubscriberModel::getConverter).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_SERIALIZER = SimpleModelAttribute.stringBuilder("Serializer", SubscriberModel.class).withDescription("The serializer used to deserialize messages.").withFunction(SubscriberModel::getSerializer).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_COMPLETE_ON_EMPTY = SimpleModelAttribute.booleanBuilder("CompleteOnEmpty", SubscriberModel.class).withDescription("A flag indicating whether the subscriber completes receive requests with a null message when the topic is empty.").withFunction(SubscriberModel::isCompleteOnEmpty).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_MEMBER = SimpleModelAttribute.stringBuilder("Member", SubscriberModel.class).withDescription("The cluster member owning this subscriber.").withFunction(SubscriberModel::getMember).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_IDENTIFYING_NAME = SimpleModelAttribute.stringBuilder("IdentifyingName", SubscriberModel.class).withDescription("An optional name to help identify this subscriber.").withFunction(SubscriberModel::getIdentifyingName).build();
    protected static final ModelAttribute<SubscriberModel> ATTRIBUTE_CHANNELS = new SubscriberChannelTableModel();
    protected static final ChannelPositionTableModel CHANNEL_HEADS_TABLE = new ChannelPositionTableModel();
    protected static final ChannelCountsTableModel<SubscriberModel> REMAINING_MESSAGES_TABLE = new ChannelCountsTableModel<SubscriberModel>(SubscriberModel::getChannelCount, SubscriberModel::getRemainingMessages);
    protected static final ModelOperation<SubscriberModel> OPERATION_DISCONNECT = SimpleModelOperation.builder("disconnect", SubscriberModel.class).withDescription("Force this subscriber to disconnect and reset itself.").withFunction(SubscriberModel::disconnect).build();
    protected static final ModelOperation<SubscriberModel> OPERATION_CONNECT = SimpleModelOperation.builder("connect", SubscriberModel.class).withDescription("Ensure this subscriber is connected.").withFunction(SubscriberModel::connect).build();
    protected static final ModelOperation<SubscriberModel> OPERATION_HEADS = SimpleModelOperation.builder("heads", SubscriberModel.class).withDescription("Retrieve the current head positions for each channel.").withFunction(SubscriberModel::getHeadsTable).returning(CHANNEL_HEADS_TABLE.getType()).build();
    protected static final ModelOperation<SubscriberModel> OPERATION_REMAINING = SimpleModelOperation.builder("remainingMessages", SubscriberModel.class).withDescription("Retrieve the count of remaining messages for each channel.").withFunction(SubscriberModel::getRemainingMessagesTable).returning(REMAINING_MESSAGES_TABLE.getType()).build();
    protected static final ModelOperation<SubscriberModel> OPERATION_NOTIFY = SimpleModelOperation.builder("notifyPopulated", SubscriberModel.class).withDescription("Send a channel populated notification to this subscriber.").withParameter("Channel", "The channel identifier", SimpleType.INTEGER).withFunction(SubscriberModel::invokeNotifyChannel).build();
    private final PagedTopicSubscriber<?> f_subscriber;

    public SubscriberModel(PagedTopicSubscriber<?> subscriber) {
        super(MBEAN_DESCRIPTION);
        this.f_subscriber = subscriber;
        this.addAttribute(ATTRIBUTE_BACKLOG);
        this.addAttribute(ATTRIBUTE_CHANNEL_ALLOCATIONS);
        this.addAttribute(ATTRIBUTE_CHANNEL_COUNT);
        this.addAttribute(ATTRIBUTE_CHANNELS);
        this.addAttribute(ATTRIBUTE_COMPLETE_ON_EMPTY);
        this.addAttribute(ATTRIBUTE_CONVERTER);
        this.addAttribute(ATTRIBUTE_DISCONNECTIONS);
        this.addAttribute(ATTRIBUTE_ELEMENTS);
        this.addAttribute(ATTRIBUTE_FILTER);
        this.addAttribute(ATTRIBUTE_ID);
        this.addAttribute(ATTRIBUTE_IDENTIFYING_NAME);
        this.addAttribute(ATTRIBUTE_MAX_BACKLOG);
        this.addAttribute(ATTRIBUTE_MEMBER);
        this.addAttribute(ATTRIBUTE_NOTIFICATIONS);
        this.addAttribute(ATTRIBUTE_NOTIFICATION_ID);
        this.addAttribute(ATTRIBUTE_POLLS);
        this.addAttribute(ATTRIBUTE_SUB_TYPE_CODE);
        this.addAttribute(ATTRIBUTE_RECEIVE_CANCELLED);
        this.addAttribute(ATTRIBUTE_RECEIVE_COMPLETIONS);
        this.addAttribute(ATTRIBUTE_RECEIVE_COMPLETIONS_MEAN);
        this.addAttribute(ATTRIBUTE_RECEIVE_COMPLETIONS_ONE);
        this.addAttribute(ATTRIBUTE_RECEIVE_COMPLETIONS_FIVE);
        this.addAttribute(ATTRIBUTE_RECEIVE_COMPLETIONS_FIFTEEN);
        this.addAttribute(ATTRIBUTE_RECEIVE_EMPTY);
        this.addAttribute(ATTRIBUTE_RECEIVE_ERRORS);
        this.addAttribute(ATTRIBUTE_RECEIVE_QUEUE);
        this.addAttribute(ATTRIBUTE_RECEIVE_REQUESTS);
        this.addAttribute(ATTRIBUTE_SERIALIZER);
        this.addAttribute(ATTRIBUTE_STATE);
        this.addAttribute(ATTRIBUTE_STATE_NAME);
        this.addAttribute(ATTRIBUTE_SUBSCRIBER_GROUP);
        this.addAttribute(ATTRIBUTE_TYPE);
        this.addAttribute(ATTRIBUTE_WAITS);
        this.addOperation(OPERATION_CONNECT);
        this.addOperation(OPERATION_DISCONNECT);
        this.addOperation(OPERATION_HEADS);
        this.addOperation(OPERATION_NOTIFY);
        this.addOperation(OPERATION_REMAINING);
    }

    protected String getSubscriberType() {
        return this.f_subscriber.getClass().getSimpleName();
    }

    protected long getId() {
        return this.f_subscriber.getId();
    }

    protected long getNotificationId() {
        return this.f_subscriber.getNotificationId();
    }

    protected String getIdentifyingName() {
        String sName = this.f_subscriber.getIdentifyingName();
        return this.valueOrNotApplicable(sName);
    }

    protected String getMember() {
        NamedTopic topic = this.f_subscriber.getNamedTopic();
        Cluster cluster = topic.getService().getCluster();
        return String.valueOf(cluster.getLocalMember());
    }

    protected String getSubscriberGroup() {
        SubscriberGroupId groupId = this.f_subscriber.getSubscriberGroupId();
        return groupId != null ? groupId.getGroupName() : null;
    }

    protected int getChannelCount() {
        return this.f_subscriber.getChannelCount();
    }

    protected String getChannels() {
        int[] aChannel = null;
        if (this.f_subscriber.isActive() && this.f_subscriber.isConnected()) {
            aChannel = this.f_subscriber.getChannels();
        }
        return aChannel == null ? "[]" : Arrays.toString(aChannel);
    }

    protected long getPolls() {
        return this.f_subscriber.getPolls();
    }

    protected int getSubTypeCode() {
        return this.f_subscriber.isAnonymous() ? 0 : 1;
    }

    protected long getElementsPolled() {
        return this.f_subscriber.getElementsPolled();
    }

    protected long getWaits() {
        return this.f_subscriber.getWaitCount();
    }

    protected long getNotifications() {
        return this.f_subscriber.getNotify();
    }

    protected int getState() {
        return this.f_subscriber.getState();
    }

    protected String getStateName() {
        return this.f_subscriber.getStateName();
    }

    protected long getBacklog() {
        return this.f_subscriber.getBacklog();
    }

    protected long getMaxBacklog() {
        return this.f_subscriber.getMaxBacklog();
    }

    protected boolean isCompleteOnEmpty() {
        return this.f_subscriber.isCompleteOnEmpty();
    }

    protected String getFilter() {
        Filter<?> filter = this.f_subscriber.getFilter();
        return this.valueOrNotApplicable(filter);
    }

    protected String getConverter() {
        ValueExtractor<?, ?> extractor = this.f_subscriber.getConverter();
        return this.valueOrNotApplicable(extractor);
    }

    protected String getSerializer() {
        return String.valueOf(this.f_subscriber.getSerializer());
    }

    protected long getReceiveCalls() {
        return this.f_subscriber.getReceiveRequests();
    }

    protected int getReceiveQueueSize() {
        return this.f_subscriber.getReceiveQueueSize();
    }

    protected long getCancelledCount() {
        return this.f_subscriber.getCancelled();
    }

    protected long getReceivedCount() {
        return this.f_subscriber.getReceived();
    }

    protected double getReceivedMeanRate() {
        return this.f_subscriber.getReceivedMeanRate();
    }

    protected double getReceivedOneMinuteRate() {
        return this.f_subscriber.getReceivedOneMinuteRate();
    }

    protected double getReceivedFiveMinuteRate() {
        return this.f_subscriber.getReceivedFiveMinuteRate();
    }

    protected double getReceivedFifteenMinuteRate() {
        return this.f_subscriber.getReceivedFifteenMinuteRate();
    }

    protected long getReceivedEmptyCount() {
        return this.f_subscriber.getReceivedEmpty();
    }

    protected long getErrorCount() {
        return this.f_subscriber.getReceivedError();
    }

    protected long getDisconnectCount() {
        return this.f_subscriber.getDisconnectCount();
    }

    protected void disconnect(Object[] aoParam) {
        this.f_subscriber.disconnect();
    }

    protected void connect(Object[] aoParam) {
        this.f_subscriber.connect();
    }

    protected Map<Integer, Position> getHeads(Object[] ignored) {
        return this.f_subscriber.getHeads();
    }

    protected Subscriber.Channel getChannel(int nChannel) {
        return this.f_subscriber.getChannel(nChannel);
    }

    protected void notifyChannel(int nChannel) {
        this.f_subscriber.notifyChannel(nChannel);
    }

    protected int getRemainingMessages(int nChannel) {
        if (nChannel < 0) {
            return this.f_subscriber.getRemainingMessages();
        }
        return this.f_subscriber.getRemainingMessages(nChannel);
    }

    protected TabularData getHeadsTable(Object[] ignored) {
        try {
            Map<Integer, Position> mapHead = this.f_subscriber.getHeads();
            return CHANNEL_HEADS_TABLE.getTabularData(mapHead);
        }
        catch (Throwable e) {
            throw Exceptions.ensureRuntimeException(e);
        }
    }

    protected TabularData getRemainingMessagesTable(Object[] ignored) {
        try {
            return REMAINING_MESSAGES_TABLE.getTabularData(this);
        }
        catch (Throwable e) {
            throw Exceptions.ensureRuntimeException(e);
        }
    }

    protected void invokeNotifyChannel(Object[] aoParam) {
        if (aoParam == null || aoParam.length != 1 || !(aoParam[0] instanceof Integer)) {
            throw new IllegalArgumentException("An integer channel identifier must be supplied");
        }
        int nChannel = (Integer)aoParam[0];
        if (nChannel < 0 || nChannel >= this.getChannelCount()) {
            throw new IllegalArgumentException("An integer channel identifier must be supplied in the range 0.." + this.getChannelCount());
        }
        this.notifyChannel(nChannel);
    }
}

