/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.management;

import com.tangosol.internal.net.management.model.AbstractModel;
import com.tangosol.internal.net.management.model.ModelAttribute;
import com.tangosol.internal.net.management.model.ModelOperation;
import com.tangosol.internal.net.management.model.SimpleModelAttribute;
import com.tangosol.internal.net.management.model.SimpleModelOperation;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.internal.net.topic.impl.paged.management.PolledMetrics;
import com.tangosol.internal.net.topic.impl.paged.management.SubscriberGroupChannelModel;
import com.tangosol.internal.net.topic.impl.paged.management.SubscriberGroupChannelTableModel;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.statistics.PagedTopicStatistics;
import com.tangosol.internal.net.topic.impl.paged.statistics.SubscriberGroupStatistics;
import com.tangosol.net.PagedTopicService;
import com.tangosol.util.Filter;
import com.tangosol.util.LongArray;
import com.tangosol.util.SimpleLongArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.management.DynamicMBean;

public class SubscriberGroupModel
extends AbstractModel<SubscriberGroupModel>
implements DynamicMBean,
PolledMetrics {
    protected static final String MBEAN_DESCRIPTION = "A Coherence PagedTopic";
    protected static final ModelAttribute<SubscriberGroupModel> ATTRIBUTE_CHANNEL_COUNT = SimpleModelAttribute.intBuilder("ChannelCount", SubscriberGroupModel.class).withDescription("The number of channels in the topic").withFunction(SubscriberGroupModel::getChannelCount).metric(false).build();
    protected static final ModelAttribute<SubscriberGroupModel> ATTRIBUTE_POLLED_COUNT = PolledMetrics.ATTRIBUTE_COUNT.asBuilder(SubscriberGroupModel.class).withFunction(SubscriberGroupModel::getPolledCount).build();
    protected static final ModelAttribute<SubscriberGroupModel> ATTRIBUTE_POLLED_MEAN = PolledMetrics.ATTRIBUTE_MEAN_RATE.asBuilder(SubscriberGroupModel.class).withFunction(SubscriberGroupModel::getPolledMeanRate).build();
    protected static final ModelAttribute<SubscriberGroupModel> ATTRIBUTE_POLLED_ONE_MINUTE = PolledMetrics.ATTRIBUTE_ONE_MINUTE_RATE.asBuilder(SubscriberGroupModel.class).withFunction(SubscriberGroupModel::getPolledOneMinuteRate).build();
    protected static final ModelAttribute<SubscriberGroupModel> ATTRIBUTE_POLLED_FIVE_MINUTE = PolledMetrics.ATTRIBUTE_FIVE_MINUTE_RATE.asBuilder(SubscriberGroupModel.class).withFunction(SubscriberGroupModel::getPolledFiveMinuteRate).build();
    protected static final ModelAttribute<SubscriberGroupModel> ATTRIBUTE_POLLED_FIFTEEN_MINUTE = PolledMetrics.ATTRIBUTE_FIFTEEN_MINUTE_RATE.asBuilder(SubscriberGroupModel.class).withFunction(SubscriberGroupModel::getPolledFifteenMinuteRate).build();
    protected static final ModelAttribute<SubscriberGroupModel> ATTRIBUTE_CHANNEL_TABLE = new SubscriberGroupChannelTableModel();
    protected static final ModelAttribute<SubscriberGroupModel> ATTRIBUTE_FILTER = SimpleModelAttribute.stringBuilder("Filter", SubscriberGroupModel.class).withDescription("The filter").withFunction(SubscriberGroupModel::getFilter).build();
    protected static final ModelAttribute<SubscriberGroupModel> ATTRIBUTE_TRANSFORMER = SimpleModelAttribute.stringBuilder("Transformer", SubscriberGroupModel.class).withDescription("The transformer").withFunction(SubscriberGroupModel::getTransformer).build();
    protected static final ModelOperation<SubscriberGroupModel> OPERATION_DISCONNECT_ALL = SimpleModelOperation.builder("disconnectAll", SubscriberGroupModel.class).withDescription("Force this subscriber group to disconnect all subscribers.").withFunction(SubscriberGroupModel::disconnectAll).build();
    private final PagedTopicStatistics f_statistics;
    private final PagedTopicService f_service;
    private final SubscriberGroupId f_groupId;
    private final Filter<?> f_filter;
    private final Function<?, ?> f_fnConvert;
    private final LongArray<SubscriberGroupChannelModel> f_aChannel = new SimpleLongArray();
    private final Lock f_lock = new ReentrantLock(true);

    public SubscriberGroupModel(PagedTopicStatistics pagedTopicStatistics, SubscriberGroupId groupId, Filter<?> filter, Function<?, ?> fnConvert, PagedTopicService service) {
        super(MBEAN_DESCRIPTION);
        this.f_groupId = groupId;
        this.f_filter = filter;
        this.f_fnConvert = fnConvert;
        this.f_statistics = pagedTopicStatistics;
        this.f_service = service;
        int cChannel = service.getChannelCount(pagedTopicStatistics.getTopicName());
        for (int nChannel = 0; nChannel < cChannel; ++nChannel) {
            this.f_aChannel.set(nChannel, new SubscriberGroupChannelModel(this.f_statistics, groupId, nChannel));
        }
        this.addAttribute(ATTRIBUTE_CHANNEL_COUNT);
        this.addAttribute(ATTRIBUTE_POLLED_COUNT);
        this.addAttribute(ATTRIBUTE_POLLED_MEAN);
        this.addAttribute(ATTRIBUTE_POLLED_ONE_MINUTE);
        this.addAttribute(ATTRIBUTE_POLLED_FIVE_MINUTE);
        this.addAttribute(ATTRIBUTE_POLLED_FIFTEEN_MINUTE);
        this.addAttribute(ATTRIBUTE_CHANNEL_TABLE);
        this.addAttribute(ATTRIBUTE_FILTER);
        this.addAttribute(ATTRIBUTE_TRANSFORMER);
        this.addOperation(OPERATION_DISCONNECT_ALL);
    }

    protected int getChannelCount() {
        return this.f_service.getChannelCount(this.f_statistics.getTopicName());
    }

    protected String getFilter() {
        return this.valueOrNotApplicable(this.f_filter);
    }

    protected String getTransformer() {
        return this.valueOrNotApplicable(this.f_fnConvert);
    }

    protected SubscriberGroupChannelModel getChannelModel(int nChannel) {
        SubscriberGroupChannelModel model = this.f_aChannel.get(nChannel);
        if (model == null) {
            this.f_lock.lock();
            try {
                model = this.f_aChannel.get(nChannel);
                if (model == null) {
                    model = new SubscriberGroupChannelModel(this.f_statistics, this.f_groupId, nChannel);
                    this.f_aChannel.set(nChannel, model);
                }
            }
            finally {
                this.f_lock.unlock();
            }
        }
        return model;
    }

    @Override
    public long getPolledCount() {
        return this.getStatistics().getPolledCount();
    }

    @Override
    public double getPolledFifteenMinuteRate() {
        return this.getStatistics().getPolledFifteenMinuteRate();
    }

    @Override
    public double getPolledFiveMinuteRate() {
        return this.getStatistics().getPolledFiveMinuteRate();
    }

    @Override
    public double getPolledOneMinuteRate() {
        return this.getStatistics().getPolledOneMinuteRate();
    }

    @Override
    public double getPolledMeanRate() {
        return this.getStatistics().getPolledMeanRate();
    }

    protected void disconnectAll(Object[] aoParam) {
        new PagedTopicCaches(this.f_statistics.getTopicName(), this.f_service, false).disconnectAllSubscribers(this.f_groupId);
    }

    protected SubscriberGroupStatistics getStatistics() {
        return this.f_statistics.getSubscriberGroupStatistics(this.f_groupId);
    }
}

