/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.management;

import com.tangosol.internal.net.topic.impl.paged.management.PolledMetrics;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.internal.net.topic.impl.paged.statistics.PagedTopicStatistics;
import com.tangosol.internal.net.topic.impl.paged.statistics.SubscriberGroupChannelStatistics;
import com.tangosol.util.UUID;
import java.time.Instant;
import java.util.Objects;

public class SubscriberGroupChannelModel
implements PolledMetrics {
    private final PagedTopicStatistics f_statistics;
    private final SubscriberGroupId f_groupId;
    private final int f_nChannel;

    public SubscriberGroupChannelModel(PagedTopicStatistics statistics, SubscriberGroupId groupId, int nChannel) {
        this.f_statistics = statistics;
        this.f_groupId = groupId;
        this.f_nChannel = nChannel;
    }

    public int getChannel() {
        return this.f_nChannel;
    }

    public String getHead() {
        return this.getStatistics().getHead().toString();
    }

    @Override
    public long getPolledCount() {
        return this.getStatistics().getPolledCount();
    }

    @Override
    public double getPolledFifteenMinuteRate() {
        return this.getStatistics().getPolledFifteenMinuteRate();
    }

    @Override
    public double getPolledFiveMinuteRate() {
        return this.getStatistics().getPolledFiveMinuteRate();
    }

    @Override
    public double getPolledOneMinuteRate() {
        return this.getStatistics().getPolledOneMinuteRate();
    }

    @Override
    public double getPolledMeanRate() {
        return this.getStatistics().getPolledMeanRate();
    }

    public long getOwningSubscriber() {
        SubscriberId subscriberId = this.getStatistics().getOwningSubscriber();
        return subscriberId == null ? -1L : subscriberId.getId();
    }

    public int getOwningSubscriberNotificationId() {
        SubscriberId subscriberId = this.getStatistics().getOwningSubscriber();
        return subscriberId == null ? -1 : subscriberId.getNotificationId();
    }

    public int getOwningSubscriberMemberId() {
        SubscriberId subscriberId = this.getStatistics().getOwningSubscriber();
        return subscriberId == null ? -1 : subscriberId.getMemberId();
    }

    public String getOwningSubscriberMemberUuid() {
        SubscriberId subscriberId = this.getStatistics().getOwningSubscriber();
        UUID uuid = subscriberId == null ? null : subscriberId.getUID();
        return String.valueOf(uuid);
    }

    public String getLastCommittedPosition() {
        return Objects.toString(this.getStatistics().getLastCommittedPosition(), "");
    }

    public String getLastCommittedTimestamp() {
        long ts = this.getStatistics().getLastCommittedTimestamp();
        return ts == 0L ? "" : Instant.ofEpochMilli(ts).toString();
    }

    public String getLastPolledTimestamp() {
        long ts = this.getStatistics().getLastPolledTimestamp();
        return ts == 0L ? "" : Instant.ofEpochMilli(ts).toString();
    }

    public long getRemainingUnpolledMessages() {
        return this.f_statistics.getChannelStatistics(this.f_nChannel).getPublishedCount() - this.getPolledCount();
    }

    private SubscriberGroupChannelStatistics getStatistics() {
        return this.f_statistics.getSubscriberGroupStatistics(this.f_groupId).getChannelStatistics(this.f_nChannel);
    }
}

