/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.management;

import com.tangosol.internal.net.management.model.AbstractModel;
import com.tangosol.internal.net.management.model.ModelAttribute;
import com.tangosol.internal.net.management.model.ModelOperation;
import com.tangosol.internal.net.management.model.SimpleModelAttribute;
import com.tangosol.internal.net.management.model.SimpleModelOperation;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicBackingMapManager;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicDependencies;
import com.tangosol.internal.net.topic.impl.paged.management.PagedTopicChannelModel;
import com.tangosol.internal.net.topic.impl.paged.management.PagedTopicChannelTableModel;
import com.tangosol.internal.net.topic.impl.paged.management.PublishedMetrics;
import com.tangosol.internal.net.topic.impl.paged.statistics.PagedTopicStatistics;
import com.tangosol.net.PagedTopicService;
import com.tangosol.util.LongArray;
import com.tangosol.util.SimpleLongArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.DynamicMBean;

public class PagedTopicModel
extends AbstractModel<PagedTopicModel>
implements DynamicMBean,
PublishedMetrics {
    protected static final String MBEAN_DESCRIPTION = "A Coherence PagedTopic.";
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_CHANNEL_COUNT = SimpleModelAttribute.intBuilder("ChannelCount", PagedTopicModel.class).withDescription("The number of channels in the topic.").withFunction(PagedTopicModel::getChannelCount).metric(false).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_PAGE_CAPACITY = SimpleModelAttribute.intBuilder("PageCapacity", PagedTopicModel.class).withDescription("The capacity of a page.").withFunction(PagedTopicModel::getPageCapacity).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_RETAIN_CONSUMED = SimpleModelAttribute.intBuilder("RetainConsumed", PagedTopicModel.class).withDescription("Retain consumed values.").withFunction(PagedTopicModel::isRetainConsumed).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_ALLOW_UNOWNED_COMMITS = SimpleModelAttribute.intBuilder("AllowUnownedCommits", PagedTopicModel.class).withDescription("Allow Unowned Commits.").withFunction(PagedTopicModel::isAllowUnownedCommits).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_SUBSCRIBER_TIMEOUT = SimpleModelAttribute.intBuilder("SubscriberTimeout", PagedTopicModel.class).withDescription("Subscriber Timeout.").withFunction(PagedTopicModel::getSubscriberTimeout).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_ELEMENT_CALCULATOR = SimpleModelAttribute.intBuilder("ElementCalculator", PagedTopicModel.class).withDescription("Element Calculator.").withFunction(PagedTopicModel::getElementCalculator).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_RECONNECT_WAIT = SimpleModelAttribute.intBuilder("ReconnectWait", PagedTopicModel.class).withDescription("Reconnect Wait.").withFunction(PagedTopicModel::getReconnectWait).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_RECONNECT_TIMEOUT = SimpleModelAttribute.intBuilder("ReconnectTimeout", PagedTopicModel.class).withDescription("Reconnect Timeout.").withFunction(PagedTopicModel::getReconnectTimeout).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_RECONNECT_RETRY = SimpleModelAttribute.intBuilder("ReconnectRetry", PagedTopicModel.class).withDescription("Reconnect Retry.").withFunction(PagedTopicModel::getReconnectRetry).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_PUBLISHED_COUNT = PublishedMetrics.ATTRIBUTE_COUNT.asBuilder(PagedTopicModel.class).withFunction(PagedTopicModel::getPublishedCount).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_PUBLISHED_MEAN = PublishedMetrics.ATTRIBUTE_MEAN_RATE.asBuilder(PagedTopicModel.class).withFunction(PagedTopicModel::getPublishedMeanRate).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_PUBLISHED_ONE_MINUTE = PublishedMetrics.ATTRIBUTE_ONE_MINUTE_RATE.asBuilder(PagedTopicModel.class).withFunction(PagedTopicModel::getPublishedOneMinuteRate).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_PUBLISHED_FIVE_MINUTE = PublishedMetrics.ATTRIBUTE_FIVE_MINUTE_RATE.asBuilder(PagedTopicModel.class).withFunction(PagedTopicModel::getPublishedFiveMinuteRate).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_PUBLISHED_FIFTEEN_MINUTE = PublishedMetrics.ATTRIBUTE_FIFTEEN_MINUTE_RATE.asBuilder(PagedTopicModel.class).withFunction(PagedTopicModel::getPublishedFifteenMinuteRate).build();
    protected static final ModelOperation<PagedTopicModel> OPERATION_DISCONNECT_ALL = SimpleModelOperation.builder("disconnectAll", PagedTopicModel.class).withDescription("Force this topic to disconnect all subscribers.").withFunction(PagedTopicModel::disconnectAll).build();
    protected static final ModelAttribute<PagedTopicModel> ATTRIBUTE_CHANNEL_TABLE = new PagedTopicChannelTableModel();
    private final PagedTopicService f_service;
    private final String f_sTopicName;
    private final LongArray<PagedTopicChannelModel> f_aChannel = new SimpleLongArray();
    private final Lock f_lock = new ReentrantLock(true);

    public PagedTopicModel(PagedTopicService service, String sTopicName) {
        super(MBEAN_DESCRIPTION);
        this.f_service = service;
        this.f_sTopicName = sTopicName;
        int cChannel = service.getChannelCount(sTopicName);
        for (int nChannel = 0; nChannel < cChannel; ++nChannel) {
            this.f_aChannel.set(nChannel, new PagedTopicChannelModel(this::getStatistics, nChannel));
        }
        this.addAttribute(ATTRIBUTE_CHANNEL_COUNT);
        this.addAttribute(ATTRIBUTE_PAGE_CAPACITY);
        this.addAttribute(ATTRIBUTE_RETAIN_CONSUMED);
        this.addAttribute(ATTRIBUTE_ALLOW_UNOWNED_COMMITS);
        this.addAttribute(ATTRIBUTE_SUBSCRIBER_TIMEOUT);
        this.addAttribute(ATTRIBUTE_ELEMENT_CALCULATOR);
        this.addAttribute(ATTRIBUTE_RECONNECT_WAIT);
        this.addAttribute(ATTRIBUTE_RECONNECT_TIMEOUT);
        this.addAttribute(ATTRIBUTE_RECONNECT_RETRY);
        this.addAttribute(ATTRIBUTE_PUBLISHED_COUNT);
        this.addAttribute(ATTRIBUTE_PUBLISHED_MEAN);
        this.addAttribute(ATTRIBUTE_PUBLISHED_ONE_MINUTE);
        this.addAttribute(ATTRIBUTE_PUBLISHED_FIVE_MINUTE);
        this.addAttribute(ATTRIBUTE_PUBLISHED_FIFTEEN_MINUTE);
        this.addAttribute(ATTRIBUTE_CHANNEL_TABLE);
        this.addOperation(OPERATION_DISCONNECT_ALL);
    }

    protected int getChannelCount() {
        return this.f_service.getChannelCount(this.f_sTopicName);
    }

    public int getPageCapacity() {
        return this.getDependencies().getPageCapacity();
    }

    public boolean isRetainConsumed() {
        return this.getDependencies().isRetainConsumed();
    }

    public boolean isAllowUnownedCommits() {
        return this.getDependencies().isAllowUnownedCommits();
    }

    public long getSubscriberTimeout() {
        return this.getDependencies().getSubscriberTimeoutMillis();
    }

    public String getElementCalculator() {
        return this.getDependencies().getElementCalculator().getName();
    }

    public long getReconnectWait() {
        return this.getDependencies().getReconnectWaitMillis();
    }

    public long getReconnectTimeout() {
        return this.getDependencies().getReconnectTimeoutMillis();
    }

    public long getReconnectRetry() {
        return this.getDependencies().getReconnectRetryMillis();
    }

    protected PagedTopicChannelModel getChannelModel(int nChannel) {
        PagedTopicChannelModel model = this.f_aChannel.get(nChannel);
        if (model == null) {
            this.f_lock.lock();
            try {
                model = this.f_aChannel.get(nChannel);
                if (model == null) {
                    model = new PagedTopicChannelModel(this::getStatistics, nChannel);
                    this.f_aChannel.set(nChannel, model);
                }
            }
            finally {
                this.f_lock.unlock();
            }
        }
        return model;
    }

    protected void disconnectAll(Object[] aoParam) {
        new PagedTopicCaches(this.f_sTopicName, this.f_service, false).disconnectAllSubscribers();
    }

    @Override
    public long getPublishedCount() {
        return this.getStatistics().getPublishedCount();
    }

    @Override
    public double getPublishedFifteenMinuteRate() {
        return this.getStatistics().getPublishedFifteenMinuteRate();
    }

    @Override
    public double getPublishedFiveMinuteRate() {
        return this.getStatistics().getPublishedFiveMinuteRate();
    }

    @Override
    public double getPublishedOneMinuteRate() {
        return this.getStatistics().getPublishedOneMinuteRate();
    }

    @Override
    public double getPublishedMeanRate() {
        return this.getStatistics().getPublishedMeanRate();
    }

    private PagedTopicDependencies getDependencies() {
        return this.f_service.getTopicBackingMapManager().getTopicDependencies(this.f_sTopicName);
    }

    private PagedTopicStatistics getStatistics() {
        return ((PagedTopicBackingMapManager)this.f_service.getBackingMapManager()).getStatistics(this.f_sTopicName);
    }
}

