/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.management;

import com.tangosol.internal.net.topic.impl.paged.management.PublishedMetrics;
import com.tangosol.internal.net.topic.impl.paged.statistics.PagedTopicChannelStatistics;
import com.tangosol.internal.net.topic.impl.paged.statistics.PagedTopicStatistics;
import java.util.function.Supplier;

public class PagedTopicChannelModel
implements PublishedMetrics {
    private final int f_nChannel;
    private final Supplier<PagedTopicStatistics> f_statistics;

    public PagedTopicChannelModel(Supplier<PagedTopicStatistics> supplier, int nChannel) {
        this.f_nChannel = nChannel;
        this.f_statistics = supplier;
    }

    public int getChannel() {
        return this.f_nChannel;
    }

    public String getTail() {
        return this.getStatistics().getTail().toString();
    }

    @Override
    public long getPublishedCount() {
        return this.getStatistics().getPublishedCount();
    }

    @Override
    public double getPublishedFifteenMinuteRate() {
        return this.getStatistics().getPublishedFifteenMinuteRate();
    }

    @Override
    public double getPublishedFiveMinuteRate() {
        return this.getStatistics().getPublishedFiveMinuteRate();
    }

    @Override
    public double getPublishedOneMinuteRate() {
        return this.getStatistics().getPublishedOneMinuteRate();
    }

    @Override
    public double getPublishedMeanRate() {
        return this.getStatistics().getPublishedMeanRate();
    }

    private PagedTopicChannelStatistics getStatistics() {
        return this.f_statistics.get().getChannelStatistics(this.f_nChannel);
    }
}

