/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.filter;

import com.oracle.coherence.common.base.Classes;
import com.tangosol.internal.net.topic.impl.paged.model.ContentKey;
import com.tangosol.internal.net.topic.impl.paged.model.PagedPosition;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.topic.Position;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.extractor.EntryExtractor;
import com.tangosol.util.filter.ExtractorFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UnreadTopicContentFilter
extends ExtractorFilter<Object, ContentKey> {
    private Map<Integer, Position> m_mapHeads;
    private Map<Integer, Position> m_mapTails;

    public UnreadTopicContentFilter() {
        super(new ContentKeyExtractor());
    }

    public UnreadTopicContentFilter(Map<Integer, Position> mapHeads, Map<Integer, Position> mapTails) {
        super(new ContentKeyExtractor());
        this.m_mapHeads = mapHeads;
        this.m_mapTails = mapTails;
    }

    @Override
    protected boolean evaluateExtracted(ContentKey extracted) {
        int nChannel = extracted.getChannel();
        PagedPosition posHead = (PagedPosition)this.m_mapHeads.get(nChannel);
        PagedPosition posTail = (PagedPosition)this.m_mapTails.get(nChannel);
        if (posHead == null || posTail == null) {
            return false;
        }
        long nHead = posHead.getPage();
        long nTail = posTail.getPage();
        long nPage = extracted.getPage();
        if (nHead >= 0L && nPage == nHead) {
            return extracted.getElement() > posHead.getOffset();
        }
        if (nTail >= 0L && nPage == nTail) {
            return extracted.getElement() <= posTail.getOffset();
        }
        return nPage > nHead && nPage < nTail;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        ClassLoader loader = Classes.getContextClassLoader();
        this.m_mapHeads = new HashMap<Integer, Position>();
        this.m_mapTails = new HashMap<Integer, Position>();
        ExternalizableHelper.readMap(in, this.m_mapHeads, loader);
        ExternalizableHelper.readMap(in, this.m_mapTails, loader);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeMap(out, this.m_mapHeads);
        ExternalizableHelper.writeMap(out, this.m_mapTails);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_mapHeads = in.readMap(0, new HashMap());
        this.m_mapTails = in.readMap(1, new HashMap());
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeMap(0, this.m_mapHeads);
        out.writeMap(1, this.m_mapTails);
    }

    public static class ContentKeyExtractor
    extends EntryExtractor {
        public Object extractFromEntry(Map.Entry entry) {
            return ContentKey.fromBinary(((BinaryEntry)entry).getBinaryKey(), true);
        }

        public Object extractOriginalFromEntry(MapTrigger.Entry entry) {
            return ContentKey.fromBinary(((BinaryEntry)((Object)entry)).getBinaryKey(), true);
        }
    }
}

