/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.agent;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicPartition;
import com.tangosol.internal.net.topic.impl.paged.agent.AbstractPagedTopicProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberInfo;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.UUID;
import java.io.IOException;
import java.util.function.Function;

public class SubscriberHeartbeatProcessor
extends AbstractPagedTopicProcessor<SubscriberInfo.Key, SubscriberInfo, Void>
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 2;
    private UUID m_uuid;
    private long m_lSubscription;
    private long m_lConnectionTimestamp;

    public SubscriberHeartbeatProcessor() {
        this(PagedTopicPartition::ensureTopic);
    }

    SubscriberHeartbeatProcessor(Function<BinaryEntry<SubscriberInfo.Key, SubscriberInfo>, PagedTopicPartition> supplier) {
        super(supplier);
    }

    public UUID getUuid() {
        return this.m_uuid;
    }

    public void setUuid(UUID uuid) {
        this.m_uuid = uuid;
    }

    public long getSubscription() {
        return this.m_lSubscription;
    }

    public void setSubscription(long lSubscription) {
        this.m_lSubscription = lSubscription;
    }

    public long getConnectionTimestamp() {
        return this.m_lConnectionTimestamp;
    }

    public void setlConnectionTimestamp(long lTimestamp) {
        this.m_lConnectionTimestamp = lTimestamp;
    }

    @Override
    public Void process(InvocableMap.Entry<SubscriberInfo.Key, SubscriberInfo> entry) {
        this.ensureTopic(entry).heartbeat(entry, this);
        return null;
    }

    @Override
    public int getImplVersion() {
        return 2;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        int nVersion = this.getDataVersion();
        if (nVersion >= 2) {
            this.m_uuid = (UUID)in.readObject(0);
            this.m_lSubscription = in.readLong(1);
            this.m_lConnectionTimestamp = in.readLong(2);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_uuid);
        out.writeLong(1, this.m_lSubscription);
        out.writeLong(2, this.m_lConnectionTimestamp);
    }
}

