/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.agent;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicPartition;
import com.tangosol.internal.net.topic.impl.paged.agent.AbstractPagedTopicProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.PagedPosition;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.IOException;
import java.util.Comparator;
import java.util.function.Function;

public class SeekProcessor
extends AbstractPagedTopicProcessor<Subscription.Key, Subscription, Result>
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 2;
    private SubscriberId m_subscriberId;
    private PagedPosition m_position;

    public SeekProcessor() {
        this(PagedTopicPartition::ensureTopic, null, SubscriberId.NullSubscriber);
    }

    public SeekProcessor(PagedPosition position, SubscriberId subscriberId) {
        this(PagedTopicPartition::ensureTopic, position, subscriberId);
    }

    SeekProcessor(Function<BinaryEntry<Subscription.Key, Subscription>, PagedTopicPartition> supplier, PagedPosition position, SubscriberId subscriberId) {
        super(supplier);
        this.m_position = position;
        this.m_subscriberId = subscriberId;
    }

    @Override
    public Result process(InvocableMap.Entry<Subscription.Key, Subscription> entry) {
        return this.ensureTopic(entry).seekPosition((BinaryEntry)entry, this.m_position, this.m_subscriberId);
    }

    @Override
    public int getImplVersion() {
        return 2;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        int nVersion = in.getVersionId();
        long nId = in.readLong(0);
        this.m_position = (PagedPosition)in.readObject(1);
        this.m_subscriberId = nVersion >= 2 ? (SubscriberId)in.readObject(2) : new SubscriberId(nId, null);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_subscriberId.getId());
        out.writeObject(1, this.m_position);
        out.writeObject(2, this.m_subscriberId);
    }

    public static class Result
    extends AbstractEvolvable
    implements EvolvablePortableObject,
    Comparable<Result> {
        public static final int RESULT_DATA_VERSION = 1;
        private static final Comparator<PagedPosition> COMPARATOR = Comparator.nullsLast(Comparator.naturalOrder());
        private PagedPosition m_positionHead;
        private PagedPosition m_positionSeek;

        public Result() {
        }

        public Result(PagedPosition positionHead, PagedPosition positionSeek) {
            this.m_positionHead = positionHead;
            this.m_positionSeek = positionSeek;
        }

        public PagedPosition getHead() {
            return this.m_positionHead;
        }

        public PagedPosition getSeekPosition() {
            return this.m_positionSeek;
        }

        @Override
        public int compareTo(Result o) {
            int n = COMPARATOR.compare(this.m_positionHead, o.m_positionHead);
            return n == 0 ? COMPARATOR.compare(this.m_positionSeek, o.m_positionSeek) : n;
        }

        @Override
        public int getImplVersion() {
            return 1;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_positionHead = (PagedPosition)in.readObject(0);
            this.m_positionSeek = (PagedPosition)in.readObject(1);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_positionHead);
            out.writeObject(1, this.m_positionSeek);
        }
    }
}

