/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.agent;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicPartition;
import com.tangosol.internal.net.topic.impl.paged.agent.AbstractPagedTopicProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;

public class PollProcessor
extends AbstractPagedTopicProcessor<Subscription.Key, Subscription, Result>
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 3;
    protected long m_lPage;
    protected int m_cElements;
    protected int m_nNotifyPostEmpty;
    private SubscriberId m_subscriberId;

    public PollProcessor() {
        super(PagedTopicPartition::ensureTopic);
    }

    public PollProcessor(long lPage, int cElements, int nNotifyPostEmpty, SubscriberId subscriberId) {
        super(PagedTopicPartition::ensureTopic);
        this.m_lPage = lPage;
        this.m_cElements = cElements;
        this.m_nNotifyPostEmpty = nNotifyPostEmpty;
        this.m_subscriberId = subscriberId;
    }

    @Override
    public Result process(InvocableMap.Entry<Subscription.Key, Subscription> entry) {
        return this.ensureTopic(entry).pollFromPageHead((BinaryEntry)entry, this.m_lPage, this.m_cElements, this.m_nNotifyPostEmpty, this.m_subscriberId);
    }

    @Override
    public int getImplVersion() {
        return 3;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_lPage = in.readLong(0);
        this.m_cElements = in.readInt(1);
        this.m_nNotifyPostEmpty = in.readInt(2);
        if (this.getDataVersion() >= 2) {
            long nId = in.readLong(3);
            this.m_subscriberId = this.getDataVersion() >= 3 ? (SubscriberId)in.readObject(4) : new SubscriberId(nId, null);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_lPage);
        out.writeInt(1, this.m_cElements);
        out.writeInt(2, this.m_nNotifyPostEmpty);
        out.writeLong(3, this.m_subscriberId.getId());
        out.writeObject(4, this.m_subscriberId);
    }

    public static class Result
    extends AbstractEvolvable
    implements EvolvablePortableObject {
        public static final int EXHAUSTED = -1;
        public static final int DATA_VERSION = 3;
        public static final int UNKNOWN_SUBSCRIBER = -2;
        public static final int NOT_ALLOCATED_CHANNEL = -3;
        private int m_cElementsRemaining;
        private int m_nNext;
        private Queue<Binary> m_queueElements;
        private long m_lSubscriptionHead = -1L;

        public Result() {
        }

        public Result(int cElementsRemaining, int nNext, Queue<Binary> queueElements, long lHead) {
            this.m_cElementsRemaining = cElementsRemaining;
            this.m_nNext = nNext;
            this.m_queueElements = queueElements == null ? new LinkedList() : queueElements;
            this.m_lSubscriptionHead = lHead;
        }

        public int getRemainingElementCount() {
            return this.m_cElementsRemaining;
        }

        public int getNextIndex() {
            return this.m_nNext;
        }

        public Queue<Binary> getElements() {
            return this.m_queueElements == null ? new LinkedList() : this.m_queueElements;
        }

        public long getSubscriptionHead() {
            return this.m_lSubscriptionHead;
        }

        public static Result exhausted(Subscription subscription) {
            return new Result(-1, Integer.MAX_VALUE, null, subscription.getSubscriptionHead());
        }

        public static Result unknownSubscriber() {
            return new Result(-2, 0, null, -1L);
        }

        public static Result notAllocated(int nNext) {
            return new Result(-3, nNext, null, -1L);
        }

        @Override
        public int getImplVersion() {
            return 3;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            int nVersion = this.getDataVersion();
            this.m_cElementsRemaining = in.readInt(0);
            this.m_nNext = in.readInt(1);
            this.m_queueElements = in.readCollection(2, new LinkedList());
            this.m_lSubscriptionHead = nVersion >= 3 ? in.readLong(3) : -1L;
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeInt(0, this.m_cElementsRemaining);
            out.writeInt(1, this.m_nNext);
            out.writeCollection(2, this.m_queueElements, Binary.class);
            out.writeLong(3, this.m_lSubscriptionHead);
        }

        public String toString() {
            return "TopicPollResult(remaining=" + this.m_cElementsRemaining + ", next=" + this.m_nNext + ", retrieved=" + String.valueOf(this.m_queueElements) + ", subscriptionHead=" + this.m_lSubscriptionHead + ")";
        }
    }
}

