/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.agent;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicPartition;
import com.tangosol.internal.net.topic.impl.paged.agent.AbstractPagedTopicProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.Page;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LongArray;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class OfferProcessor
extends AbstractPagedTopicProcessor<Page.Key, Page, Result>
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 2;
    protected List<Binary> m_listValues;
    protected int m_nNotifyPostFull;
    protected boolean m_fSealPage;

    public OfferProcessor() {
        super(PagedTopicPartition::ensureTopic);
    }

    public OfferProcessor(List<Binary> listElements, int nNotifyPostFull, boolean fSealPage) {
        this(listElements, nNotifyPostFull, fSealPage, PagedTopicPartition::ensureTopic);
    }

    protected OfferProcessor(List<Binary> listElements, int nNotifyPostFull, boolean fSealPage, Function<BinaryEntry<Page.Key, Page>, PagedTopicPartition> supplier) {
        super(supplier);
        this.m_listValues = listElements;
        this.m_nNotifyPostFull = nNotifyPostFull;
        this.m_fSealPage = fSealPage;
    }

    public List<Binary> getElements() {
        return this.m_listValues;
    }

    public void setValues(List<Binary> listValues) {
        this.m_listValues = listValues;
    }

    @Override
    public Result process(InvocableMap.Entry<Page.Key, Page> entry) {
        return this.ensureTopic(entry).offerToPageTail((BinaryEntry)entry, this);
    }

    public List<Binary> getListValues() {
        return this.m_listValues;
    }

    public int getNotifyPostFull() {
        return this.m_nNotifyPostFull;
    }

    public boolean isSealPage() {
        return this.m_fSealPage;
    }

    @Override
    public int getImplVersion() {
        return 2;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_listValues = in.readCollection(0, new LinkedList());
        this.m_nNotifyPostFull = in.readInt(1);
        this.m_fSealPage = in.readBoolean(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeCollection(0, this.m_listValues, Binary.class);
        out.writeInt(1, this.m_nNotifyPostFull);
        out.writeBoolean(2, this.m_fSealPage);
    }

    public static class Result
    extends AbstractEvolvable
    implements EvolvablePortableObject {
        public static final int DATA_VERSION = 2;
        protected Status m_status;
        protected int m_cAccepted;
        protected int m_cbPageFree;
        protected LongArray<Throwable> m_aErrors;
        protected int m_nOffset;

        public Result() {
        }

        public Result(Status status, int cAccepted, int cbFree, int nOffset) {
            this(status, cAccepted, cbFree, null, nOffset);
        }

        public Result(Status status, int cAccepted, int cbFree, LongArray<Throwable> aErrors, int nOffset) {
            this.m_status = status;
            this.m_cAccepted = cAccepted;
            this.m_cbPageFree = cbFree;
            this.m_aErrors = aErrors;
            this.m_nOffset = nOffset;
        }

        public int getAcceptedCount() {
            return this.m_cAccepted;
        }

        public Status getStatus() {
            return this.m_status;
        }

        public int getPageCapacity() {
            return this.m_cbPageFree;
        }

        public LongArray<Throwable> getErrors() {
            return this.m_aErrors;
        }

        public int getOffset() {
            return this.m_nOffset;
        }

        @Override
        public int getImplVersion() {
            return 2;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_status = Status.valueOf(in.readString(0));
            this.m_cAccepted = in.readInt(1);
            this.m_cbPageFree = in.readInt(2);
            this.m_aErrors = (LongArray)in.readObject(3);
            if (this.getImplVersion() >= 2) {
                this.m_nOffset = in.readInt(4);
            }
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeString(0, this.m_status.name());
            out.writeInt(1, this.m_cAccepted);
            out.writeInt(2, this.m_cbPageFree);
            out.writeObject(3, this.m_aErrors);
            out.writeInt(4, this.m_nOffset);
        }

        public String toString() {
            return "Result( status=" + String.valueOf((Object)this.m_status) + ", offset=" + this.m_nOffset + ", accepted=" + this.m_cAccepted + ", pageFree=" + this.m_cbPageFree + ", errors=" + String.valueOf(this.m_aErrors) + ")";
        }

        public static enum Status {
            Success,
            PageSealed,
            TopicFull;

        }
    }
}

