/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.agent;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicPartition;
import com.tangosol.internal.net.topic.impl.paged.agent.AbstractPagedTopicProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.topic.TopicException;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.UUID;
import com.tangosol.util.ValueExtractor;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;

public class EnsureSubscriptionProcessor
extends AbstractPagedTopicProcessor<Subscription.Key, Subscription, Result>
implements EvolvablePortableObject {
    public static final int PHASE_INQUIRE = 0;
    public static final int PHASE_PIN = 1;
    public static final int PHASE_ADVANCE = 2;
    public static final int DATA_VERSION = 4;
    private int m_nPhase;
    private long[] m_alPage;
    private Filter<?> m_filter;
    private ValueExtractor<?, ?> m_extractor;
    private SubscriberId m_subscriberId;
    private boolean m_fReconnect;
    private boolean m_fCreateGroupOnly;
    private long m_lSubscriptionId;

    public EnsureSubscriptionProcessor() {
        super(PagedTopicPartition::ensureTopic);
    }

    public EnsureSubscriptionProcessor(int nPhase, long[] alPage, Filter<?> filter, ValueExtractor<?, ?> extractor, SubscriberId subscriberId, boolean fReconnect, boolean fCreateGroupOnly, long lSubscriptionId) {
        super(PagedTopicPartition::ensureTopic);
        this.m_nPhase = nPhase;
        this.m_alPage = alPage;
        this.m_filter = filter;
        this.m_extractor = extractor;
        this.m_subscriberId = subscriberId;
        this.m_fReconnect = fReconnect;
        this.m_fCreateGroupOnly = fCreateGroupOnly;
        this.m_lSubscriptionId = lSubscriptionId;
    }

    @Override
    public Result process(InvocableMap.Entry<Subscription.Key, Subscription> entry) {
        try {
            long[] alPage = this.ensureTopic(entry).ensureSubscription(entry.getKey(), this);
            return new Result(alPage, this.m_lSubscriptionId, null);
        }
        catch (Throwable thrown) {
            Logger.err(thrown);
            return new Result(null, this.m_lSubscriptionId, thrown);
        }
    }

    public int getPhase() {
        return this.m_nPhase;
    }

    public long[] getPages() {
        return this.m_alPage;
    }

    public Filter<?> getFilter() {
        return this.m_filter;
    }

    public ValueExtractor<?, ?> getConverter() {
        return this.m_extractor;
    }

    public SubscriberId getSubscriberId() {
        return this.m_subscriberId;
    }

    public boolean isReconnect() {
        return this.m_fReconnect;
    }

    public boolean isCreateGroupOnly() {
        return this.m_fCreateGroupOnly;
    }

    public long getSubscriptionId() {
        return this.m_lSubscriptionId;
    }

    public void setSubscriptionId(long lSubscriptionId) {
        this.m_lSubscriptionId = lSubscriptionId;
    }

    @Override
    public int getImplVersion() {
        return 4;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        int nVersion = this.getDataVersion();
        UUID uuid = null;
        long nSubscriberId = 0L;
        this.m_nPhase = in.readInt(0);
        this.m_alPage = in.readLongArray(1);
        this.m_filter = (Filter)in.readObject(2);
        this.m_extractor = (ValueExtractor)in.readObject(3);
        if (nVersion >= 2) {
            nSubscriberId = in.readLong(4);
            this.m_fReconnect = in.readBoolean(5);
            this.m_fCreateGroupOnly = in.readBoolean(6);
        }
        if (nVersion >= 3) {
            uuid = (UUID)in.readObject(7);
        }
        if (nVersion >= 4) {
            this.m_lSubscriptionId = in.readLong(8);
        }
        this.m_subscriberId = new SubscriberId(nSubscriberId, uuid);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nPhase);
        out.writeLongArray(1, this.m_alPage);
        out.writeObject(2, this.m_filter);
        out.writeObject(3, this.m_extractor);
        out.writeObject(4, this.m_subscriberId.getId());
        out.writeBoolean(5, this.m_fReconnect);
        out.writeBoolean(6, this.m_fCreateGroupOnly);
        out.writeObject(7, this.m_subscriberId.getUID());
        out.writeLong(8, this.m_lSubscriptionId);
    }

    public static class Result
    extends AbstractEvolvable
    implements EvolvablePortableObject {
        public static final int DATA_VERSION = 3;
        private long[] m_alPage;
        private Throwable m_error;
        private long m_lSubscription;

        public Result() {
        }

        public Result(long[] alPage, long lSubscription, Throwable error) {
            this.m_alPage = alPage;
            this.m_lSubscription = lSubscription;
            this.m_error = error;
        }

        public boolean hasError() {
            return this.m_error != null;
        }

        public long[] getPages() {
            return this.m_alPage;
        }

        public Throwable getError() {
            return this.m_error;
        }

        public long getSubscription() {
            return this.m_lSubscription;
        }

        @Override
        public int getImplVersion() {
            return 3;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            int nVersion = this.getDataVersion();
            this.m_alPage = in.readLongArray(0);
            this.m_error = (Throwable)in.readObject(1);
            if (nVersion >= 3) {
                this.m_lSubscription = in.readLong(2);
            }
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeLongArray(0, this.m_alPage);
            out.writeObject(1, this.m_error);
            out.writeLong(2, this.m_lSubscription);
        }

        public static Collection<long[]> assertPages(Collection<Result> colResult) {
            if (colResult == null) {
                return null;
            }
            TopicException error = Result.findFirstError(colResult);
            if (error != null) {
                throw error;
            }
            return Result.getPages(colResult);
        }

        public static TopicException findFirstError(Collection<Result> colResult) {
            if (colResult == null) {
                return null;
            }
            return colResult.stream().filter(Result::hasError).map(Result::getError).map(TopicException::new).findFirst().orElse(null);
        }

        public static Collection<long[]> getPages(Collection<Result> colResult) {
            if (colResult == null) {
                return null;
            }
            return colResult.stream().filter(r -> !r.hasError()).map(Result::getPages).collect(Collectors.toList());
        }
    }
}

