/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.agent;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicPartition;
import com.tangosol.internal.net.topic.impl.paged.agent.AbstractPagedTopicProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.InvocableMap;
import java.io.IOException;

public class DestroySubscriptionProcessor
extends AbstractPagedTopicProcessor<Subscription.Key, Subscription, Void>
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 2;
    private long m_lSubscriptionId;

    public DestroySubscriptionProcessor() {
        super(PagedTopicPartition::ensureTopic);
    }

    public DestroySubscriptionProcessor(long lSubscriptionId) {
        super(PagedTopicPartition::ensureTopic);
        this.m_lSubscriptionId = lSubscriptionId;
    }

    @Override
    public Void process(InvocableMap.Entry<Subscription.Key, Subscription> entry) {
        this.ensureTopic(entry).removeSubscription(entry.getKey().getGroupId(), this.m_lSubscriptionId);
        return null;
    }

    @Override
    public int getImplVersion() {
        return 2;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        int nVersion = this.getDataVersion();
        if (nVersion > 1) {
            this.m_lSubscriptionId = in.readLong(0);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_lSubscriptionId);
    }
}

