/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.agent;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicPartition;
import com.tangosol.internal.net.topic.impl.paged.agent.AbstractPagedTopicProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.PagedPosition;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.IOException;
import java.util.function.Function;

public class CommitProcessor
extends AbstractPagedTopicProcessor<Subscription.Key, Subscription, Subscriber.CommitResult>
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 2;
    private SubscriberId m_subscriberId;
    private PagedPosition m_position;

    public CommitProcessor() {
        this(PagedTopicPartition::ensureTopic, null, SubscriberId.NullSubscriber);
    }

    public CommitProcessor(PagedPosition position, SubscriberId subscriberId) {
        this(PagedTopicPartition::ensureTopic, position, subscriberId);
    }

    CommitProcessor(Function<BinaryEntry<Subscription.Key, Subscription>, PagedTopicPartition> supplier, PagedPosition position, SubscriberId subscriberId) {
        super(supplier);
        this.m_position = position;
        this.m_subscriberId = subscriberId;
    }

    @Override
    public Subscriber.CommitResult process(InvocableMap.Entry<Subscription.Key, Subscription> entry) {
        return this.ensureTopic(entry).commitPosition((BinaryEntry)entry, this.m_position, this.m_subscriberId);
    }

    @Override
    public int getImplVersion() {
        return 2;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        int nVersion = in.getVersionId();
        long nId = in.readLong(0);
        this.m_position = (PagedPosition)in.readObject(1);
        this.m_subscriberId = nVersion >= 2 ? (SubscriberId)in.readObject(2) : new SubscriberId(nId, null);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_subscriberId.getId());
        out.writeObject(1, this.m_position);
        out.writeObject(2, this.m_subscriberId);
    }
}

