/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged.agent;

import com.tangosol.internal.net.topic.impl.paged.PagedTopicPartition;
import com.tangosol.internal.net.topic.impl.paged.agent.AbstractPagedTopicProcessor;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.internal.net.topic.impl.paged.model.Subscription;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.InvocableMap;
import java.io.IOException;
import java.util.Objects;

public class CloseSubscriptionProcessor
extends AbstractPagedTopicProcessor<Subscription.Key, Subscription, long[]>
implements EvolvablePortableObject {
    public static final int DATA_VERSION = 2;
    private SubscriberId m_subscriberId;

    public CloseSubscriptionProcessor() {
        super(PagedTopicPartition::ensureTopic);
    }

    public CloseSubscriptionProcessor(SubscriberId subscriberId) {
        super(PagedTopicPartition::ensureTopic);
        this.m_subscriberId = Objects.requireNonNull(subscriberId);
    }

    @Override
    public long[] process(InvocableMap.Entry<Subscription.Key, Subscription> entry) {
        this.ensureTopic(entry).closeSubscription(entry.getKey(), this.m_subscriberId);
        return null;
    }

    @Override
    public int getImplVersion() {
        return 2;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        int nVersion = in.getVersionId();
        long nId = in.readLong(0);
        this.m_subscriberId = nVersion >= 2 ? (SubscriberId)in.readObject(1) : new SubscriberId(nId, null);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_subscriberId.getId());
        out.writeObject(1, this.m_subscriberId);
    }
}

