/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.topic.impl.paged.agent.CleanupSubscribers;
import com.tangosol.internal.util.Daemons;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.partition.PartitionEvent;
import com.tangosol.net.partition.PartitionListener;
import com.tangosol.net.partition.PartitionSet;
import java.util.concurrent.CompletableFuture;

public class SubscriberCleanupListener
implements MemberListener,
PartitionListener {
    @Override
    public void onPartitionEvent(PartitionEvent evt) {
        DistributedCacheService service = (DistributedCacheService)evt.getService();
        int nId = evt.getId();
        if (nId == 6) {
            this.cleanup(evt);
        } else if (nId == 8) {
            PartitionSet parts;
            int nTo;
            int nLocal = service.getCluster().getLocalMember().getId();
            Member member = evt.getToMember();
            int n = nTo = member == null ? -1 : member.getId();
            if (nTo == nLocal && (parts = evt.getPartitionSet()) != null) {
                this.cleanup(evt);
            }
        }
    }

    @Override
    public void memberLeft(MemberEvent evt) {
        DistributedCacheService service = (DistributedCacheService)evt.getService();
        CompletableFuture.runAsync(() -> {
            if (!evt.isLocal()) {
                CleanupSubscribers processor = new CleanupSubscribers();
                processor.execute(service);
            }
        }, Daemons.commonPool()).handle((ignored, err) -> {
            if (err != null && evt.getService().isRunning()) {
                Logger.finer("Error invoking subscriber clean-up", err);
            }
            return null;
        });
    }

    @Override
    public void memberJoined(MemberEvent evt) {
    }

    @Override
    public void memberLeaving(MemberEvent evt) {
    }

    private void cleanup(PartitionEvent evt) {
        DistributedCacheService service = (DistributedCacheService)evt.getService();
        CompletableFuture.runAsync(() -> {
            CleanupSubscribers processor = new CleanupSubscribers();
            processor.execute(service, evt.getPartitionSet());
        }, Daemons.commonPool()).handle((ignored, err) -> {
            if (err != null && evt.getService().isRunning()) {
                Logger.finer("Error invoking subscriber clean-up", err);
            }
            return null;
        });
    }
}

