/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.topic.ChannelAllocationStrategy;
import com.tangosol.internal.net.topic.impl.paged.model.PagedTopicSubscription;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.util.UUID;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class PagedTopicConfigMap {
    public static Set<String> getTopicNames(Map<?, ?> configMap) {
        return configMap.keySet().stream().filter(key -> key instanceof String).map(String.class::cast).collect(Collectors.toSet());
    }

    public static Set<SubscriberGroupId> getSubscriberGroups(Map<?, ?> configMap, String sTopicName) {
        return configMap.keySet().stream().filter(v -> v instanceof PagedTopicSubscription.Key).map(PagedTopicSubscription.Key.class::cast).filter(key -> key.getTopicName().equals(sTopicName)).map(PagedTopicSubscription.Key::getGroupId).collect(Collectors.toSet());
    }

    public static Set<SubscriberId> getSubscribers(Map<?, ?> configMap, String sTopicName, SubscriberGroupId groupId) {
        PagedTopicSubscription subscription = PagedTopicConfigMap.getSubscription(configMap, sTopicName, groupId);
        if (subscription != null) {
            return subscription.getSubscriberIds();
        }
        return Collections.emptySet();
    }

    public static Iterable<PagedTopicSubscription> getSubscriptions(Map<?, ?> configMap) {
        return configMap.values().stream().filter(v -> v instanceof PagedTopicSubscription).map(PagedTopicSubscription.class::cast).collect(Collectors.toList());
    }

    public static void updateSubscription(Map<Object, Object> configMap, PagedTopicSubscription subscription) {
        configMap.put(subscription.getKey(), subscription);
    }

    public static PagedTopicSubscription getSubscription(Map<?, ?> configMap, long lSubscriptionId) {
        return configMap.values().stream().filter(PagedTopicSubscription.class::isInstance).map(PagedTopicSubscription.class::cast).filter(s -> s.getSubscriptionId() == lSubscriptionId).findFirst().orElse(null);
    }

    public static PagedTopicSubscription getSubscription(Map<?, ?> configMap, String sTopicName, SubscriberGroupId groupId) {
        return (PagedTopicSubscription)configMap.get(new PagedTopicSubscription.Key(sTopicName, groupId));
    }

    public static long getSubscriptionId(Map<?, ?> configMap, String sTopicName, SubscriberGroupId groupId) {
        PagedTopicSubscription subscription = PagedTopicConfigMap.getSubscription(configMap, sTopicName, groupId);
        return subscription == null ? 0L : subscription.getSubscriptionId();
    }

    public static void removeSubscription(Map<Object, Object> configMap, PagedTopicSubscription.Key key) {
        configMap.computeIfPresent(key, (k, v) -> null);
    }

    public static boolean hasSubscription(Map<?, ?> configMap, long lSubscriptionId, SubscriberId subscriberId) {
        PagedTopicSubscription subscription = PagedTopicConfigMap.getSubscription(configMap, lSubscriptionId);
        if (subscription != null) {
            return subscriberId == null || subscription.hasSubscriber(subscriberId);
        }
        return false;
    }

    public static boolean hasSubscriptions(Map<?, ?> configMap, String sTopic) {
        return configMap.keySet().stream().filter(key -> key instanceof PagedTopicSubscription.Key).map(PagedTopicSubscription.Key.class::cast).anyMatch(key -> key.getTopicName().equals(sTopic));
    }

    public static long getSubscriptionCount(Map<?, ?> configMap, String sTopic) {
        return configMap.keySet().stream().filter(key -> key instanceof PagedTopicSubscription.Key).map(PagedTopicSubscription.Key.class::cast).filter(key -> key.getTopicName().equals(sTopic)).count();
    }

    public static void setChannelCount(Map<?, ?> configMap, String sTopic, int cChannel, ChannelAllocationStrategy strategy) {
        Set setKey = configMap.keySet().stream().filter(key -> key instanceof PagedTopicSubscription.Key).map(PagedTopicSubscription.Key.class::cast).filter(key -> key.getTopicName().equals(sTopic)).collect(Collectors.toSet());
        Map<?, ?> mapSub = configMap;
        for (PagedTopicSubscription.Key key2 : setKey) {
            PagedTopicSubscription subscription = (PagedTopicSubscription)configMap.get(key2);
            if (subscription.getChannelCount() >= cChannel) continue;
            Logger.config("Updating channel count for subscription " + key2.getGroupName() + " in topic " + sTopic + " to " + cChannel);
            subscription.updateChannelAllocations(strategy, cChannel);
            mapSub.put(key2, subscription);
        }
    }

    public static void removeTopic(Map<?, ?> configMap, String sTopicName) {
        configMap.remove(sTopicName);
        Set<PagedTopicSubscription.Key> setKeys = configMap.keySet().stream().filter(v -> v instanceof PagedTopicSubscription.Key).map(PagedTopicSubscription.Key.class::cast).filter(key -> key.getTopicName().equals(sTopicName)).collect(Collectors.toSet());
        setKeys.forEach(configMap::remove);
    }

    public static Map<String, Map<SubscriptionAndGroup, Set<SubscriberId>>> getDepartedSubscriptions(Map<?, ?> configMap, Set<UUID> setMember) {
        HashMap<String, Map<SubscriptionAndGroup, Set<SubscriberId>>> mapDeparted = new HashMap<String, Map<SubscriptionAndGroup, Set<SubscriberId>>>();
        for (Map.Entry<?, ?> entry : configMap.entrySet()) {
            PagedTopicSubscription subscription;
            Set<SubscriberId> setDeparted;
            Object oKey = entry.getKey();
            if (!(oKey instanceof PagedTopicSubscription.Key) || (setDeparted = (subscription = (PagedTopicSubscription)entry.getValue()).getDepartedSubscribers(setMember)).isEmpty()) continue;
            String sTopicName = subscription.getKey().getTopicName();
            HashMap<SubscriptionAndGroup, Set<SubscriberId>> map = (HashMap<SubscriptionAndGroup, Set<SubscriberId>>)mapDeparted.get(sTopicName);
            if (map == null) {
                map = new HashMap<SubscriptionAndGroup, Set<SubscriberId>>();
            }
            SubscriptionAndGroup sg = new SubscriptionAndGroup(subscription.getSubscriptionId(), subscription.getSubscriberGroupId());
            map.put(sg, setDeparted);
            mapDeparted.put(sTopicName, map);
        }
        return mapDeparted;
    }

    public static class SubscriptionAndGroup {
        private final long f_lSubscription;
        private final SubscriberGroupId f_groupId;

        public SubscriptionAndGroup(long lSubscription, SubscriberGroupId groupId) {
            this.f_lSubscription = lSubscription;
            this.f_groupId = groupId;
        }

        public long getSubscriptionId() {
            return this.f_lSubscription;
        }

        public SubscriberGroupId getSubscriberGroupId() {
            return this.f_groupId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscriptionAndGroup that = (SubscriptionAndGroup)o;
            return this.f_lSubscription == that.f_lSubscription && Objects.equals(this.f_groupId, that.f_groupId);
        }

        public int hashCode() {
            return Objects.hash(this.f_lSubscription, this.f_groupId);
        }
    }
}

