/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.tangosol.coherence.config.scheme.PagedTopicScheme;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicDependencies;
import com.tangosol.internal.net.topic.impl.paged.statistics.PagedTopicStatistics;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.topic.TopicBackingMapManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PagedTopicBackingMapManager
extends TopicBackingMapManager<PagedTopicDependencies, PagedTopicScheme> {
    private final Lock m_lock = new ReentrantLock(true);
    private final Map<String, PagedTopicDependencies> m_mapDeps = new HashMap<String, PagedTopicDependencies>();
    private final Map<String, PagedTopicStatistics> m_mapStatistics = new HashMap<String, PagedTopicStatistics>();

    public PagedTopicBackingMapManager(ExtensibleConfigurableCacheFactory eccf) {
        super(eccf);
    }

    @Override
    public PagedTopicScheme findTopicScheme(String sName) {
        return (PagedTopicScheme)this.getCacheFactory().getCacheConfig().findSchemeByTopicName(sName);
    }

    @Override
    public PagedTopicDependencies getTopicDependencies(String sTopicName) {
        PagedTopicDependencies deps = this.m_mapDeps.get(sTopicName);
        if (deps == null) {
            this.m_lock.lock();
            try {
                deps = this.m_mapDeps.computeIfAbsent(sTopicName, this::createTopicDependencies);
            }
            finally {
                this.m_lock.unlock();
            }
        }
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map instantiateBackingMap(String sName) {
        this.m_lock.lock();
        try {
            Map map = super.instantiateBackingMap(sName);
            String sTopicName = PagedTopicCaches.Names.getTopicName(sName);
            this.ensureStatistics(sTopicName);
            Map map2 = map;
            return map2;
        }
        finally {
            this.m_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseBackingMap(String sName, Map map) {
        this.m_lock.lock();
        try {
            super.releaseBackingMap(sName, map);
            String sTopicName = PagedTopicCaches.Names.getTopicName(sName);
            this.m_mapDeps.remove(sTopicName);
            this.m_mapStatistics.remove(sTopicName);
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public PagedTopicStatistics getStatistics(String sTopicName) {
        PagedTopicStatistics statistics = this.m_mapStatistics.get(sTopicName);
        if (statistics == null) {
            this.m_lock.lock();
            try {
                statistics = this.ensureStatistics(sTopicName);
            }
            finally {
                this.m_lock.unlock();
            }
        }
        return statistics;
    }

    private PagedTopicDependencies createTopicDependencies(String sName) {
        ClassLoader loader = PagedTopicBackingMapManager.getContextClassLoader();
        ParameterResolver resolver = this.getCacheFactory().getParameterResolver(sName, loader, this.getContext());
        PagedTopicScheme scheme = this.findTopicScheme(sName);
        if (scheme == null) {
            throw new IllegalStateException("Cannot find paged-topic-scheme for topic " + sName);
        }
        return scheme.createConfiguration(resolver, loader);
    }

    private PagedTopicStatistics createStatistics(PagedTopicDependencies dependencies, String sTopicName) {
        return new PagedTopicStatistics(dependencies.getConfiguredChannelCount(), sTopicName);
    }

    private PagedTopicStatistics ensureStatistics(String sTopicName) {
        PagedTopicDependencies dependencies = this.m_mapDeps.computeIfAbsent(sTopicName, this::createTopicDependencies);
        return this.m_mapStatistics.computeIfAbsent(sTopicName, s -> this.createStatistics(dependencies, sTopicName));
    }
}

