/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.tangosol.coherence.config.unit.Seconds;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicCaches;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicDependencies;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicPublisher;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicSubscriber;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberGroupId;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.CacheService;
import com.tangosol.net.Service;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Publisher;
import com.tangosol.net.topic.Subscriber;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import java.util.Objects;
import java.util.Set;

public class PagedTopic<V>
implements NamedTopic<V>,
ClassLoaderAware {
    public static final int DEFAULT_CHANNEL_COUNT = 0;
    public static final long DEFAULT_PAGE_CAPACITY_BYTES = 0x100000L;
    public static final Seconds DEFAULT_SUBSCRIBER_TIMEOUT_SECONDS = new Seconds(300);
    public static final Seconds DEFAULT_RECONNECT_TIMEOUT_SECONDS = new Seconds(300);
    public static final Seconds DEFAULT_RECONNECT_RETRY_SECONDS = new Seconds(5);
    public static final Seconds DEFAULT_RECONNECT_WAIT_SECONDS = new Seconds(10);
    private final PagedTopicCaches f_pagedTopicCaches;

    public PagedTopic(PagedTopicCaches pagedTopicCaches) {
        this.f_pagedTopicCaches = pagedTopicCaches;
    }

    public PagedTopicDependencies getDependencies() {
        return this.f_pagedTopicCaches.getDependencies();
    }

    @Override
    public <U> Subscriber<U> createSubscriber(Subscriber.Option<? super V, U> ... options) {
        this.ensureActive();
        this.f_pagedTopicCaches.ensureConnected();
        return new PagedTopicSubscriber<U>(this, this.f_pagedTopicCaches, options);
    }

    @Override
    public void ensureSubscriberGroup(String sName, Filter<?> filter, ValueExtractor<?, ?> extractor) {
        this.f_pagedTopicCaches.ensureSubscriberGroup(sName, filter, extractor);
    }

    @Override
    public void destroySubscriberGroup(String sGroupName) {
        if (sGroupName == null) {
            throw new IllegalArgumentException("invalid group name");
        }
        PagedTopicSubscriber.destroy(this.f_pagedTopicCaches, SubscriberGroupId.withName(sGroupName), 0L);
    }

    @Override
    public Set<String> getSubscriberGroups() {
        return this.f_pagedTopicCaches.getSubscriberGroups();
    }

    @Override
    public Publisher<V> createPublisher(Publisher.Option<? super V> ... options) {
        this.ensureActive();
        return new PagedTopicPublisher<V>(this, this.f_pagedTopicCaches, options);
    }

    @Override
    public void destroy() {
        this.f_pagedTopicCaches.destroy();
    }

    @Override
    public Service getService() {
        return this.getCacheService();
    }

    public CacheService getCacheService() {
        return this.f_pagedTopicCaches.getService();
    }

    @Override
    public String getName() {
        return this.f_pagedTopicCaches.getTopicName();
    }

    @Override
    public void release() {
        if (this.f_pagedTopicCaches.isActive()) {
            this.f_pagedTopicCaches.release();
        }
    }

    @Override
    public boolean isActive() {
        return this.f_pagedTopicCaches.isActive();
    }

    @Override
    public boolean isDestroyed() {
        return this.f_pagedTopicCaches.isDestroyed();
    }

    @Override
    public boolean isReleased() {
        return this.f_pagedTopicCaches.isReleased();
    }

    @Override
    public int getChannelCount() {
        return this.f_pagedTopicCaches.getChannelCount();
    }

    @Override
    public int getRemainingMessages(String sSubscriberGroup, int ... anChannel) {
        return this.f_pagedTopicCaches.getRemainingMessages(SubscriberGroupId.withName(sSubscriberGroup), anChannel);
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return this.f_pagedTopicCaches.getContextClassLoader();
    }

    @Override
    public void setContextClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagedTopic that = (PagedTopic)o;
        return Objects.equals(this.f_pagedTopicCaches, that.f_pagedTopicCaches);
    }

    public int hashCode() {
        return Objects.hash(this.f_pagedTopicCaches);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(name=" + this.f_pagedTopicCaches.getTopicName() + ")";
    }

    protected void ensureActive() {
        if (!this.f_pagedTopicCaches.isActive()) {
            throw new IllegalStateException("This topic is no longer active");
        }
    }
}

