/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic.impl.paged;

import com.oracle.coherence.common.util.Duration;
import com.tangosol.internal.net.topic.impl.paged.PagedTopic;
import com.tangosol.internal.net.topic.impl.paged.PagedTopicDependencies;
import com.tangosol.internal.util.Primes;
import com.tangosol.net.topic.BinaryElementCalculator;
import com.tangosol.net.topic.NamedTopic;

public class DefaultPagedTopicDependencies
implements PagedTopicDependencies {
    private final int m_cPartition;
    private int m_cChannel;
    private int m_cbPageCapacity = 0;
    private long m_cbServerCapacity = Long.MAX_VALUE;
    private long m_cMillisExpiry = 0L;
    private long m_cbMaxBatch;
    private boolean m_fRetainConsumed;
    private long m_cSubscriberTimeoutMillis = PagedTopic.DEFAULT_SUBSCRIBER_TIMEOUT_SECONDS.as(Duration.Magnitude.MILLI);
    private boolean m_fAllowUnownedCommits;
    private NamedTopic.ElementCalculator m_calculator = BinaryElementCalculator.INSTANCE;
    private long m_cReconnectTimeoutMillis = PagedTopic.DEFAULT_RECONNECT_TIMEOUT_SECONDS.as(Duration.Magnitude.MILLI);
    private long m_cReconnectRetryMillis = PagedTopic.DEFAULT_RECONNECT_RETRY_SECONDS.as(Duration.Magnitude.MILLI);
    private long m_cReconnectWaitMillis = PagedTopic.DEFAULT_RECONNECT_WAIT_SECONDS.as(Duration.Magnitude.MILLI);

    public DefaultPagedTopicDependencies(int cPartition) {
        this.m_cPartition = cPartition;
    }

    public DefaultPagedTopicDependencies(PagedTopicDependencies deps) {
        this(0);
        this.setAllowUnownedCommits(deps.isAllowUnownedCommits());
        this.setChannelCount(deps.getConfiguredChannelCount());
        this.setElementCalculator(deps.getElementCalculator());
        this.setElementExpiryMillis(deps.getElementExpiryMillis());
        this.setMaxBatchSizeBytes(deps.getMaxBatchSizeBytes());
        this.setPageCapacity(deps.getPageCapacity());
        this.setReconnectRetryMillis(deps.getReconnectRetryMillis());
        this.setReconnectTimeoutMillis(deps.getReconnectTimeoutMillis());
        this.setReconnectWaitMillis(deps.getReconnectWaitMillis());
        this.setRetainConsumed(deps.isRetainConsumed());
        this.setServerCapacity(deps.getServerCapacity());
        this.setSubscriberTimeoutMillis(deps.getSubscriberTimeoutMillis());
    }

    @Override
    public int getConfiguredChannelCount() {
        int cChannel = this.m_cChannel;
        if (cChannel == 0) {
            cChannel = this.m_cChannel = DefaultPagedTopicDependencies.computeChannelCount(this.m_cPartition);
        }
        return cChannel;
    }

    public static int computeChannelCount(int cPartitions) {
        return Math.min(cPartitions, Primes.next((int)Math.sqrt(cPartitions)));
    }

    public void setChannelCount(int nChannel) {
        if (nChannel < 0) {
            throw new IllegalArgumentException("Invalid channel count, valid values are positive non-zero integers");
        }
        this.m_cChannel = nChannel;
    }

    @Override
    public int getPageCapacity() {
        return this.m_cbPageCapacity;
    }

    public void setPageCapacity(int cbPageCapacity) {
        this.m_cbPageCapacity = cbPageCapacity;
    }

    @Override
    public long getServerCapacity() {
        return this.m_cbServerCapacity;
    }

    public void setServerCapacity(long cbServer) {
        this.m_cbServerCapacity = cbServer;
    }

    @Override
    public long getElementExpiryMillis() {
        return this.m_cMillisExpiry;
    }

    public void setElementExpiryMillis(long cMillisExpiry) {
        this.m_cMillisExpiry = cMillisExpiry;
    }

    @Override
    public long getMaxBatchSizeBytes() {
        return this.m_cbMaxBatch;
    }

    public void setMaxBatchSizeBytes(long cb) {
        this.m_cbMaxBatch = cb;
    }

    @Override
    public boolean isRetainConsumed() {
        return this.m_fRetainConsumed;
    }

    public void setRetainConsumed(boolean fRetainElements) {
        this.m_fRetainConsumed = fRetainElements;
    }

    @Override
    public long getSubscriberTimeoutMillis() {
        return this.m_cSubscriberTimeoutMillis;
    }

    public void setSubscriberTimeoutMillis(long cMillis) {
        this.m_cSubscriberTimeoutMillis = cMillis <= 0L ? -1L : Math.max(1000L, cMillis);
    }

    @Override
    public long getNotificationTimeout() {
        if (this.m_cSubscriberTimeoutMillis == -1L) {
            return -1L;
        }
        return this.m_cSubscriberTimeoutMillis / 2L;
    }

    @Override
    public boolean isAllowUnownedCommits() {
        return this.m_fAllowUnownedCommits;
    }

    @Override
    public boolean isOnlyOwnedCommits() {
        return !this.m_fAllowUnownedCommits;
    }

    public void setAllowUnownedCommits(boolean f) {
        this.m_fAllowUnownedCommits = f;
    }

    @Override
    public NamedTopic.ElementCalculator getElementCalculator() {
        return this.m_calculator;
    }

    public void setElementCalculator(NamedTopic.ElementCalculator calculator) {
        this.m_calculator = calculator == null ? BinaryElementCalculator.INSTANCE : calculator;
    }

    @Override
    public long getReconnectTimeoutMillis() {
        return this.m_cReconnectTimeoutMillis;
    }

    public void setReconnectTimeoutMillis(long cMillis) {
        this.m_cReconnectTimeoutMillis = cMillis <= 0L ? 0L : Math.max(1000L, cMillis);
    }

    @Override
    public long getReconnectRetryMillis() {
        return this.m_cReconnectRetryMillis;
    }

    public void setReconnectRetryMillis(long cMillis) {
        this.m_cReconnectRetryMillis = cMillis <= 0L ? 0L : Math.max(1000L, cMillis);
    }

    @Override
    public long getReconnectWaitMillis() {
        return this.m_cReconnectWaitMillis;
    }

    public void setReconnectWaitMillis(long cMillis) {
        this.m_cReconnectWaitMillis = cMillis <= 0L ? 1000L : Math.max(1000L, cMillis);
    }

    public String toString() {
        return "PageTopicScheme Configuration: Page=" + this.m_cbPageCapacity + "b, CacheServerMaxStorage=" + this.m_cbServerCapacity + ",Expiry=" + this.m_cMillisExpiry + "ms, MaxBatch=" + this.m_cbMaxBatch + "b, RetainConsumed=" + this.m_fRetainConsumed + ", ElementCalculator=" + this.m_calculator.getName() + ", SubscriberTimeout=" + this.m_cSubscriberTimeoutMillis + "ms ReconnectWait=" + this.m_cReconnectWaitMillis + "ms ReconnectTimeout=" + this.m_cReconnectTimeoutMillis + "ms ReconnectRetry=" + this.m_cReconnectRetryMillis + "ms AllowUnownedCommits=" + this.m_fAllowUnownedCommits;
    }
}

