/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.topic;

import com.tangosol.internal.net.topic.ChannelAllocationStrategy;
import com.tangosol.internal.net.topic.impl.paged.model.SubscriberId;
import com.tangosol.net.Member;
import com.tangosol.util.UUID;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SimpleChannelAllocationStrategy
implements ChannelAllocationStrategy {
    @Override
    public SortedMap<Integer, Set<SubscriberId>> cleanup(SortedMap<Long, SubscriberId> mapSubscriber, Set<Member> setMember) {
        TreeMap<Integer, Set<SubscriberId>> mapRemoved = new TreeMap<Integer, Set<SubscriberId>>();
        Set setMemberUID = setMember.stream().map(Member::getUuid).collect(Collectors.toSet());
        Set setMemberID = setMember.stream().map(Member::getId).collect(Collectors.toSet());
        for (Map.Entry<Long, SubscriberId> entry : mapSubscriber.entrySet()) {
            SubscriberId subscriberId = entry.getValue();
            UUID uuid = subscriberId.getUID();
            int nMemberId = subscriberId.getMemberId();
            if (uuid == null && !setMemberID.contains(nMemberId)) {
                mapRemoved.compute(nMemberId, (key, set) -> this.ensureSet(nMemberId, subscriberId, (Set<SubscriberId>)set));
                continue;
            }
            if (setMemberUID.contains(uuid)) continue;
            mapRemoved.compute(nMemberId, (key, set) -> this.ensureSet(nMemberId, subscriberId, (Set<SubscriberId>)set));
        }
        mapRemoved.values().stream().flatMap(Collection::stream).forEach(id -> mapSubscriber.remove(id.getId()));
        return mapRemoved;
    }

    @Override
    public long[] allocate(SortedMap<Long, SubscriberId> mapSubscriber, int cChannel) {
        long[] alChannel;
        block4: {
            int cSubscriber;
            block7: {
                block6: {
                    block5: {
                        alChannel = new long[cChannel];
                        cSubscriber = mapSubscriber.size();
                        if (cSubscriber != 0) break block5;
                        Arrays.fill(alChannel, 0L);
                        break block4;
                    }
                    if (cSubscriber != 1) break block6;
                    Arrays.fill(alChannel, mapSubscriber.values().iterator().next().getId());
                    break block4;
                }
                if (cSubscriber < cChannel) break block7;
                int nChannel = 0;
                for (Map.Entry<Long, SubscriberId> entry : mapSubscriber.entrySet()) {
                    alChannel[nChannel++] = entry.getValue().getId();
                    if (nChannel < cChannel) continue;
                    break block4;
                }
                break block4;
            }
            int nChannel = 0;
            int cAlloc = cChannel / cSubscriber;
            for (Map.Entry<Long, SubscriberId> entry : mapSubscriber.entrySet()) {
                for (int i = 0; i < cAlloc; ++i) {
                    alChannel[nChannel++] = entry.getValue().getId();
                }
            }
            if (nChannel >= cChannel) break block4;
            for (Map.Entry<Long, SubscriberId> entry : mapSubscriber.entrySet()) {
                alChannel[nChannel++] = entry.getValue().getId();
                if (nChannel < cChannel) continue;
                break;
            }
        }
        return alChannel;
    }

    private Set<SubscriberId> ensureSet(Integer ignored, SubscriberId id, Set<SubscriberId> setId) {
        if (setId == null) {
            setId = new HashSet<SubscriberId>();
        }
        setId.add(id);
        return setId;
    }
}

