/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.ssl.KeyStoreListener;
import com.tangosol.net.PasswordProvider;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;

public class SafeKeyStoreListener
implements KeyStoreListener {
    private final KeyStoreListener m_delegate;

    public SafeKeyStoreListener(KeyStoreListener delegate) {
        this.m_delegate = delegate;
    }

    @Override
    public void identityStoreLoaded(KeyStore keyStore, PasswordProvider provider) {
        try {
            this.m_delegate.identityStoreLoaded(keyStore, provider);
        }
        catch (Throwable t) {
            Logger.err(t);
        }
    }

    @Override
    public void identityStoreLoaded(PrivateKey key, PasswordProvider provider, Certificate[] aCert) {
        try {
            this.m_delegate.identityStoreLoaded(key, provider, aCert);
        }
        catch (Throwable t) {
            Logger.err(t);
        }
    }

    @Override
    public void trustStoreLoaded(KeyStore keyStore, PasswordProvider provider) {
        try {
            this.m_delegate.trustStoreLoaded(keyStore, provider);
        }
        catch (Throwable t) {
            Logger.err(t);
        }
    }

    @Override
    public void trustStoreLoaded(Certificate[] aCert) {
        try {
            this.m_delegate.trustStoreLoaded(aCert);
        }
        catch (Throwable t) {
            Logger.err(t);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof SafeKeyStoreListener) {
            SafeKeyStoreListener that = (SafeKeyStoreListener)o;
            return Objects.equals(this.m_delegate, that.m_delegate);
        }
        if (o instanceof KeyStoreListener) {
            return Objects.equals(this.m_delegate, o);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_delegate);
    }
}

