/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.net.SSLSocketProvider;
import com.tangosol.internal.net.ssl.SSLContextDependencies;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLContextSpiImpl
extends SSLContextSpi
implements SSLContextDependencies.Listener {
    private SSLContextDependencies m_dependencies;
    private volatile SSLContext m_sslContext;

    @Override
    public void onUpdate(SSLContextDependencies dependencies) throws GeneralSecurityException {
        Provider provider = this.m_dependencies.getProvider();
        String sProviderName = this.m_dependencies.getProviderName();
        String sProtocol = this.m_dependencies.getProtocol();
        SSLContext ctx = provider != null ? SSLContext.getInstance(sProtocol, provider) : (sProviderName != null && !sProviderName.isBlank() ? SSLContext.getInstance(sProtocol, sProviderName) : SSLContext.getInstance(sProtocol));
        KeyManager[] aKeyManager = this.m_dependencies.getKeyManagers();
        TrustManager[] aTrustManagers = this.m_dependencies.getTrustManagers();
        SecureRandom secureRandom = this.m_dependencies.getSecureRandom();
        ctx.init(aKeyManager, aTrustManagers, secureRandom);
        SSLSocketProvider.ClientAuthMode mode = this.m_dependencies.getClientAuth();
        switch (mode) {
            case wanted: {
                ctx.getDefaultSSLParameters().setWantClientAuth(true);
                ctx.getDefaultSSLParameters().setNeedClientAuth(false);
                break;
            }
            case required: {
                ctx.getDefaultSSLParameters().setWantClientAuth(true);
                ctx.getDefaultSSLParameters().setNeedClientAuth(true);
                break;
            }
            default: {
                ctx.getDefaultSSLParameters().setWantClientAuth(false);
                ctx.getDefaultSSLParameters().setNeedClientAuth(false);
            }
        }
        this.m_sslContext = ctx;
    }

    @Override
    public void onError(SSLContextDependencies dependencies, Throwable t) throws KeyManagementException {
        if (this.m_sslContext == null) {
            throw new KeyManagementException("Could not create first SSLContext. Expect communication errors.", t);
        }
        Logger.err("Could not properly instantiate SSLContext. The existing SSLContext will be used", t);
    }

    @Override
    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) {
        this.m_dependencies.init(keyManagers, trustManagers, secureRandom);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return this.m_sslContext.getSocketFactory();
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return this.m_sslContext.getServerSocketFactory();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        return this.m_sslContext.createSSLEngine();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String remoteHost, int remotePort) {
        return this.m_sslContext.createSSLEngine(remoteHost, remotePort);
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.m_sslContext.getServerSessionContext();
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.m_sslContext.getClientSessionContext();
    }

    public void setDependencies(SSLContextDependencies dependencies) {
        this.m_dependencies = new SSLContextDependencies(dependencies, this);
        this.m_dependencies.init();
    }
}

