/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.tangosol.internal.net.ssl.SSLContextDependencies;
import com.tangosol.internal.net.ssl.SSLContextSpiImpl;
import com.tangosol.internal.net.ssl.SSLSocketProviderDefaultDependencies;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.Objects;

public class SSLContextProvider
extends Provider {
    public static final String NAME = "CoherenceSSLContextProvider";
    public static final String SERVICE_TYPE = "SSLContext";
    private final SSLSocketProviderDefaultDependencies m_depsSocketProvider;

    public SSLContextProvider(String sProtocol, SSLSocketProviderDefaultDependencies depsSocketProvider) {
        super(NAME, 1.0, "This provider provides the default Coherence SSLContext");
        this.m_depsSocketProvider = depsSocketProvider;
        if (sProtocol == null || sProtocol.isEmpty()) {
            sProtocol = "TLS";
        }
        this.putService(new SSLContextService(this, sProtocol));
    }

    protected class SSLContextService
    extends Provider.Service {
        private final String m_sProtocol;

        protected SSLContextService(Provider provider, String sProtocol) {
            super(provider, SSLContextProvider.SERVICE_TYPE, Objects.requireNonNull(sProtocol), SSLContextSpiImpl.class.getName(), Collections.emptyList(), Collections.emptyMap());
            this.m_sProtocol = sProtocol;
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            SSLContextSpiImpl sslContext = (SSLContextSpiImpl)super.newInstance(constructorParameter);
            SSLContextDependencies dependencies = SSLContextProvider.this.m_depsSocketProvider.getSSLContextDependencies();
            dependencies.setProtocol(this.m_sProtocol);
            sslContext.setDependencies(dependencies);
            return sslContext;
        }
    }
}

