/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.net.SSLSocketProvider;
import com.tangosol.internal.net.ssl.DefaultKeyManagerBuilder;
import com.tangosol.internal.net.ssl.DefaultTrustManagerBuilder;
import com.tangosol.internal.net.ssl.KeyManagersBuilder;
import com.tangosol.internal.net.ssl.ManagerDependencies;
import com.tangosol.internal.net.ssl.TrustManagersBuilder;
import com.tangosol.net.ssl.RefreshPolicy;
import com.tangosol.util.Base;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

public class SSLContextDependencies {
    private volatile SecureRandom m_secureRandom;
    private volatile KeyManager[] m_aKeyManager;
    private volatile TrustManager[] m_aTrustManagers;
    private volatile KeyManagersBuilder m_keyManagersBuilder;
    private volatile TrustManagersBuilder m_trustManagersBuilder;
    private SSLSocketProvider.Dependencies m_deps;
    private ManagerDependencies m_depsIdMgr;
    private ManagerDependencies m_depsTrustMgr;
    private String m_sProtocol;
    private Provider m_provider;
    private String m_sProviderName;
    private SSLSocketProvider.ClientAuthMode m_clientAuthMode;
    private boolean m_fClientAuthModeUnset;
    private long m_nRefreshPeriodMillis;
    private static final AtomicLong INSTANCE_COUNT = new AtomicLong(0L);
    private final Listener m_listener;

    public SSLContextDependencies(Listener listener) {
        this.m_listener = listener;
    }

    public SSLContextDependencies(SSLContextDependencies deps, Listener listener) {
        this(listener);
        if (deps != null) {
            this.m_secureRandom = deps.m_secureRandom;
            this.m_aKeyManager = deps.m_aKeyManager;
            this.m_aTrustManagers = deps.m_aTrustManagers;
            this.m_keyManagersBuilder = deps.m_keyManagersBuilder;
            this.m_trustManagersBuilder = deps.m_trustManagersBuilder;
            this.m_deps = deps.m_deps;
            this.m_depsIdMgr = deps.m_depsIdMgr;
            this.m_depsTrustMgr = deps.m_depsTrustMgr;
            this.m_sProtocol = deps.m_sProtocol;
            this.m_provider = deps.m_provider;
            this.m_sProviderName = deps.m_sProviderName;
            this.m_clientAuthMode = deps.m_clientAuthMode;
            this.m_fClientAuthModeUnset = deps.m_clientAuthMode == null;
            this.m_nRefreshPeriodMillis = deps.m_nRefreshPeriodMillis;
        }
    }

    public void init() {
        this.init(this.m_aKeyManager, this.m_aTrustManagers, this.m_secureRandom);
    }

    protected void init(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) {
        this.m_aKeyManager = keyManagers;
        this.m_aTrustManagers = trustManagers;
        this.m_secureRandom = secureRandom;
        try {
            this.update();
            if (this.m_nRefreshPeriodMillis > 0L) {
                ScheduledExecutorService refreshExecutor = Executors.newSingleThreadScheduledExecutor(SSLContextDependencies::makeRefreshThread);
                refreshExecutor.scheduleAtFixedRate(this::onScheduledUpdate, this.m_nRefreshPeriodMillis, this.m_nRefreshPeriodMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            throw Exceptions.ensureRuntimeException(e);
        }
    }

    public void setDependencies(SSLSocketProvider.Dependencies deps, ManagerDependencies depsIdMgr, ManagerDependencies depsTrustMgr) {
        this.m_deps = deps;
        this.m_depsIdMgr = depsIdMgr;
        this.m_depsTrustMgr = depsTrustMgr;
    }

    public SecureRandom getSecureRandom() {
        return this.m_secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.m_secureRandom = secureRandom;
    }

    public KeyManager[] getKeyManagers() {
        return this.m_aKeyManager;
    }

    public TrustManager[] getTrustManagers() {
        return this.m_aTrustManagers;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.m_deps.getHostnameVerifier();
    }

    public void setClientAuth(SSLSocketProvider.ClientAuthMode mode) {
        this.m_fClientAuthModeUnset = mode == null;
        this.m_clientAuthMode = mode;
    }

    public SSLSocketProvider.ClientAuthMode getClientAuth() {
        return this.m_clientAuthMode;
    }

    public void setProvider(Provider provider, String sProviderName) {
        this.m_provider = provider;
        this.m_sProviderName = sProviderName;
    }

    public Provider getProvider() {
        return this.m_provider;
    }

    public String getProviderName() {
        return this.m_sProviderName;
    }

    public void setRefreshPeriodInMillis(long nRefreshPeriodInMillis) {
        this.m_nRefreshPeriodMillis = nRefreshPeriodInMillis;
    }

    public long getRefreshPeriodMillis() {
        return this.m_nRefreshPeriodMillis;
    }

    public String[] getEnabledCipherSuites() {
        return this.m_deps.getEnabledCipherSuites();
    }

    public void setProtocol(String sProtocol) {
        this.m_sProtocol = sProtocol;
    }

    public String getProtocol() {
        if (this.m_sProtocol == null || this.m_sProtocol.isEmpty()) {
            return "TLS";
        }
        return this.m_sProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyManagersBuilder ensureKeyManagersBuilder() {
        if (this.m_keyManagersBuilder == null) {
            SSLContextDependencies sSLContextDependencies = this;
            synchronized (sSLContextDependencies) {
                if (this.m_keyManagersBuilder == null) {
                    KeyManagersBuilder builder = this.m_provider instanceof KeyManagersBuilder ? (KeyManagersBuilder)((Object)this.m_provider) : new DefaultKeyManagerBuilder();
                    this.m_keyManagersBuilder = builder;
                }
            }
        }
        return this.m_keyManagersBuilder;
    }

    protected void setKeyManagersBuilder(KeyManagersBuilder keyManagersBuilder) {
        this.m_keyManagersBuilder = keyManagersBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TrustManagersBuilder ensureTrustManagersBuilder() {
        if (this.m_trustManagersBuilder == null) {
            SSLContextDependencies sSLContextDependencies = this;
            synchronized (sSLContextDependencies) {
                if (this.m_trustManagersBuilder == null) {
                    TrustManagersBuilder builder = this.m_provider instanceof TrustManagersBuilder ? (TrustManagersBuilder)((Object)this.m_provider) : new DefaultTrustManagerBuilder();
                    this.m_trustManagersBuilder = builder;
                }
            }
        }
        return this.m_trustManagersBuilder;
    }

    protected void setTrustManagersBuilder(TrustManagersBuilder trustManagersBuilder) {
        this.m_trustManagersBuilder = trustManagersBuilder;
    }

    protected static Thread makeRefreshThread(Runnable runnable) {
        String sName = "SSLContextRefreshThread:" + INSTANCE_COUNT.incrementAndGet();
        return Base.makeThread(null, runnable, sName);
    }

    protected void onScheduledUpdate() {
        try {
            RefreshPolicy policy = this.m_deps.getRefreshPolicy();
            if (policy == null || policy.shouldRefresh(this.m_deps, this.m_depsIdMgr, this.m_depsTrustMgr)) {
                this.update();
            }
        }
        catch (Throwable t) {
            Logger.err("Failed to update keystores", t);
        }
    }

    protected synchronized void update() throws KeyManagementException {
        try {
            StringBuilder sbDesc = new StringBuilder();
            KeyManagersBuilder keyManagersBuilder = this.ensureKeyManagersBuilder();
            TrustManagersBuilder trustManagersBuilder = this.ensureTrustManagersBuilder();
            if (!keyManagersBuilder.isRefreshable(this.m_depsIdMgr) && !trustManagersBuilder.isRefreshable(this.m_depsTrustMgr)) {
                return;
            }
            this.m_aKeyManager = keyManagersBuilder.buildKeyManagers(this.m_depsIdMgr, sbDesc);
            this.m_aTrustManagers = trustManagersBuilder.buildTrustManagers(this.m_depsTrustMgr, sbDesc.append(", "));
            if (this.m_fClientAuthModeUnset) {
                this.m_clientAuthMode = this.m_aTrustManagers == null || this.m_aTrustManagers.length == 0 ? SSLSocketProvider.ClientAuthMode.none : SSLSocketProvider.ClientAuthMode.required;
            }
            this.m_deps.setClientAuth(this.m_clientAuthMode);
            if (this.m_listener != null) {
                this.m_listener.onUpdate(this);
            }
            this.logDescription(sbDesc);
        }
        catch (Throwable e) {
            if (this.m_listener != null) {
                this.m_listener.onError(this, e);
            }
            throw new KeyManagementException("Could not create SSLContext dependencies", e);
        }
    }

    protected void logDescription(StringBuilder sbDesc) {
        if (this.m_deps.getHostnameVerifier() != null) {
            sbDesc.append(", hostname-verifier=custom");
        }
        String sAuth = this.m_aKeyManager == null && this.m_aTrustManagers == null ? "none" : (this.m_aKeyManager == null ? "one-way client" : (this.m_aTrustManagers == null ? "one-way server" : (this.m_clientAuthMode == SSLSocketProvider.ClientAuthMode.none ? "one-way" : "two-way")));
        sbDesc.insert(0, "SSLSocketProvider(auth=" + sAuth + ", ").append(", clientAuth=").append((Object)this.m_clientAuthMode).append(')');
        this.m_deps.setDescription(sbDesc.toString());
        Logger.fine("instantiated SSLSocketProviderDependencies: " + String.valueOf(sbDesc));
    }

    public static interface Listener {
        public void onUpdate(SSLContextDependencies var1) throws GeneralSecurityException;

        public void onError(SSLContextDependencies var1, Throwable var2) throws KeyManagementException;
    }
}

