/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.oracle.coherence.common.base.Reads;
import com.tangosol.net.PasswordProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PemReader {
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);
    private static final Pattern PUBLIC_KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PUBLIC\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n\\s]+)-+END\\s+.*PUBLIC\\s+KEY[^-]*-+", 2);

    private PemReader() {
    }

    public static PrivateKey readPrivateKey(InputStream in, PasswordProvider provider) throws IOException {
        PrivateKeyInfo pkInfo = PemReader.readPrivateKeyBytes(Reads.read(in));
        switch (pkInfo.type) {
            case "PKCS1-RSA": {
                throw new SecurityException("PKCS#1 RSA private key is not supported");
            }
            case "PKCS1-DSA": {
                throw new SecurityException("PKCS#1 DSA private key is not supported");
            }
            case "PKCS1-EC": {
                throw new SecurityException("PKCS#1 EC private key is not supported");
            }
        }
        return PemReader.pkcs8(PemReader.generateKeySpec(pkInfo.bytes, provider));
    }

    public static Certificate[] readCertificates(InputStream in) throws IOException {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new SecurityException("Failed to create certificate factory", e);
        }
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        String content = new String(Reads.read(in), StandardCharsets.US_ASCII);
        Matcher matcher = CERT_PATTERN.matcher(content);
        int start = 0;
        while (matcher.find(start)) {
            byte[] base64 = matcher.group(1).getBytes(StandardCharsets.US_ASCII);
            byte[] der = Base64.getMimeDecoder().decode(base64);
            try {
                certs.add(cf.generateCertificate(new ByteArrayInputStream(der)));
            }
            catch (Exception e) {
                throw new IOException("Failed to read certificate from bytes", e);
            }
            start = matcher.end();
        }
        if (certs.isEmpty()) {
            throw new SecurityException("Found no certificates in input stream");
        }
        return certs.toArray(new Certificate[0]);
    }

    private static PrivateKey pkcs8(KeySpec keySpec) {
        try {
            return PemReader.rsaPrivateKey(keySpec);
        }
        catch (Exception rsaException) {
            try {
                return PemReader.dsaPrivateKey(keySpec);
            }
            catch (Exception dsaException) {
                try {
                    return PemReader.ecPrivateKey(keySpec);
                }
                catch (Exception ecException) {
                    SecurityException e = new SecurityException("Failed to get private key. It is not RSA, DSA or EC.");
                    e.addSuppressed(rsaException);
                    e.addSuppressed(dsaException);
                    e.addSuppressed(ecException);
                    throw e;
                }
            }
        }
    }

    private static PrivateKey ecPrivateKey(KeySpec keySpec) {
        try {
            return KeyFactory.getInstance("EC").generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new SecurityException("Failed to get EC private key", e);
        }
    }

    private static PrivateKey dsaPrivateKey(KeySpec keySpec) {
        try {
            return KeyFactory.getInstance("DSA").generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new SecurityException("Failed to get DSA private key", e);
        }
    }

    private static PrivateKey rsaPrivateKey(KeySpec keySpec) {
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new SecurityException("Failed to get RSA private key", e);
        }
    }

    /*
     * Loose catch block
     */
    private static KeySpec generateKeySpec(byte[] keyBytes, PasswordProvider provider) {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec;
        char[] acPassword;
        block5: {
            acPassword = null;
            char[] cArray = acPassword = provider == null ? null : provider.get();
            if (acPassword != null && acPassword.length != 0) break block5;
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec2 = new PKCS8EncodedKeySpec(keyBytes);
            {
                catch (Throwable throwable) {
                    PasswordProvider.reset(new char[][]{acPassword});
                    throw throwable;
                }
            }
            PasswordProvider.reset(new char[][]{acPassword});
            return pKCS8EncodedKeySpec2;
        }
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(keyBytes);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
            PBEKeySpec pbeKeySpec = new PBEKeySpec(acPassword);
            SecretKey pbeKey = keyFactory.generateSecret(pbeKeySpec);
            Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
            cipher.init(2, (Key)pbeKey, encryptedPrivateKeyInfo.getAlgParameters());
            pKCS8EncodedKeySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
        }
        catch (Exception e) {
            throw new SecurityException("Failed to create key spec for key", e);
        }
        PasswordProvider.reset(new char[][]{acPassword});
        return pKCS8EncodedKeySpec;
    }

    private static PrivateKeyInfo readPrivateKeyBytes(byte[] ab) {
        String type;
        String content = new String(ab, StandardCharsets.US_ASCII);
        Matcher matcher = KEY_PATTERN.matcher(content);
        if (!matcher.find()) {
            throw new SecurityException("Could not find a PKCS#8 private key in input stream");
        }
        byte[] base64 = matcher.group(1).getBytes(StandardCharsets.US_ASCII);
        if (content.startsWith("-----BEGIN PRIVATE KEY-----") || content.startsWith("-----BEGIN ENCRYPTED PRIVATE KEY-----")) {
            type = "PKCS8";
        } else if (content.startsWith("-----BEGIN RSA PRIVATE KEY-----")) {
            type = "PKCS1-RSA";
        } else if (content.startsWith("-----BEGIN DSA PRIVATE KEY-----")) {
            type = "PKCS1-DSA";
        } else if (content.startsWith("-----BEGIN EC PRIVATE KEY-----")) {
            type = "PKCS1-EC";
        } else {
            int firstEol = content.indexOf("\n");
            if (firstEol < 1) {
                throw new SecurityException("Could not find a PKCS#8 private key in input stream");
            }
            throw new SecurityException("Unsupported key type: " + content.substring(0, firstEol));
        }
        return new PrivateKeyInfo(type, Base64.getMimeDecoder().decode(base64));
    }

    private static final class PrivateKeyInfo {
        private final String type;
        private final byte[] bytes;

        private PrivateKeyInfo(String type, byte[] bytes) {
            this.type = type;
            this.bytes = bytes;
        }
    }
}

