/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.tangosol.coherence.config.builder.SSLSocketProviderDependenciesBuilder;
import com.tangosol.internal.net.ssl.AbstractManagerBuilder;
import com.tangosol.internal.net.ssl.KeyStoreListener;
import com.tangosol.internal.net.ssl.KeystoreDependencies;
import com.tangosol.internal.net.ssl.ManagerDependencies;
import com.tangosol.internal.net.ssl.TrustManagersBuilder;
import com.tangosol.net.PasswordProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class DefaultTrustManagerBuilder
extends AbstractManagerBuilder
implements TrustManagersBuilder {
    @Override
    public TrustManager[] buildTrustManagers(ManagerDependencies deps, StringBuilder sb) throws GeneralSecurityException, IOException {
        if (deps == null) {
            sb.append("trust=unspecified");
            return null;
        }
        TrustManagerFactory factory = this.createTrustManagerFactory(deps);
        KeystoreDependencies depsKeystore = deps.getKeystoreDependencies();
        List<KeyStoreListener> listeners = deps.getListeners();
        sb.append("trust=").append(deps.getAlgorithm()).append('/');
        KeyStore keyStore = this.resolveKeystore(deps, depsKeystore, PasswordProvider.NullImplementation, listeners, false, sb);
        factory.init(keyStore);
        return factory.getTrustManagers();
    }

    @Override
    public boolean isRefreshable(ManagerDependencies deps) {
        KeystoreDependencies depsKeyStore = deps == null ? null : deps.getKeystoreDependencies();
        return this.shouldRefresh(deps, depsKeyStore);
    }

    protected TrustManagerFactory createTrustManagerFactory(ManagerDependencies deps) throws GeneralSecurityException {
        TrustManagerFactory factory = null;
        SSLSocketProviderDependenciesBuilder.ProviderBuilder providerBuilder = deps.getProviderBuilder();
        String sAlgorithm = deps.getAlgorithm();
        if (providerBuilder != null) {
            Provider provider = providerBuilder.realize(null, null, null);
            if (provider == null) {
                String sName = providerBuilder.getName();
                if (sName != null) {
                    factory = TrustManagerFactory.getInstance(sAlgorithm, sName);
                }
            } else {
                if (provider instanceof ManagerDependencies.Aware) {
                    ((ManagerDependencies.Aware)((Object)provider)).setDependencies(deps);
                }
                factory = TrustManagerFactory.getInstance(sAlgorithm, provider);
            }
        }
        if (factory == null) {
            factory = TrustManagerFactory.getInstance(sAlgorithm);
        }
        return factory;
    }
}

