/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.SSLSocketProviderDependenciesBuilder;
import com.tangosol.coherence.config.xml.processor.PasswordProviderBuilderProcessor;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.ssl.KeyStoreListener;
import com.tangosol.internal.net.ssl.KeystoreDependencies;
import com.tangosol.internal.net.ssl.ManagerDependencies;
import com.tangosol.internal.net.ssl.SafeKeyStoreListener;
import com.tangosol.net.PasswordProvider;
import com.tangosol.net.ssl.CertificateLoader;
import com.tangosol.net.ssl.PrivateKeyLoader;
import java.util.ArrayList;
import java.util.List;

public class DefaultManagerDependencies
implements ManagerDependencies {
    private final String f_sNameManagerKind;
    private SSLSocketProviderDependenciesBuilder.ProviderBuilder m_bldrProvider;
    private KeystoreDependencies m_depsKeystore = KeystoreDependencies.NullImplementation;
    private String m_sAlgorithm;
    private PasswordProvider m_passProvider;
    private PrivateKeyLoader m_privateKeyLoader;
    private CertificateLoader[] m_aCertificateLoader;
    private final List<KeyStoreListener> m_listeners = new ArrayList<KeyStoreListener>();

    public DefaultManagerDependencies(String sNameManagerKind) {
        this.f_sNameManagerKind = sNameManagerKind;
    }

    @Override
    public String getAlgorithm() {
        if (this.m_sAlgorithm == null) {
            if (this.f_sNameManagerKind.equals("trust-manager")) {
                this.m_sAlgorithm = "SunX509";
            } else if (this.f_sNameManagerKind.equals("identity-manager")) {
                this.m_sAlgorithm = "SunX509";
            } else {
                throw new IllegalArgumentException("unknown manager: " + this.f_sNameManagerKind + "; expected either identity-manager or trust-manager");
            }
        }
        return this.m_sAlgorithm;
    }

    @Override
    public SSLSocketProviderDependenciesBuilder.ProviderBuilder getProviderBuilder() {
        return this.m_bldrProvider;
    }

    @Override
    public KeystoreDependencies getKeystoreDependencies() {
        return this.m_depsKeystore;
    }

    @Override
    public PasswordProvider getPrivateKeyPasswordProvider() {
        if (null == this.m_passProvider) {
            ParameterizedBuilder<PasswordProvider> bldr = PasswordProviderBuilderProcessor.getNullPasswordProviderBuilder();
            this.m_passProvider = bldr.realize(null, null, null);
        }
        return this.m_passProvider;
    }

    @Override
    public void addListener(KeyStoreListener listener) {
        if (listener != null) {
            this.m_listeners.add(new SafeKeyStoreListener(listener));
        }
    }

    @Override
    public void removeListener(KeyStoreListener listener) {
        if (listener != null) {
            this.m_listeners.remove(listener);
        }
    }

    @Override
    public List<KeyStoreListener> getListeners() {
        return this.m_listeners;
    }

    public void setPrivateKeyLoader(PrivateKeyLoader loader) {
        this.m_privateKeyLoader = loader;
    }

    @Override
    public PrivateKeyLoader getPrivateKeyLoader() {
        return this.m_privateKeyLoader;
    }

    public void setCertificateLoaders(CertificateLoader[] aLoader) {
        this.m_aCertificateLoader = aLoader;
    }

    @Override
    public CertificateLoader[] getCertificateLoaders() {
        return this.m_aCertificateLoader;
    }

    @Injectable(value="password")
    public void setPassword(String sPassword) {
        ParameterizedBuilder<PasswordProvider> bldr = PasswordProviderBuilderProcessor.getPasswordProviderBuilderForPasswordStr(sPassword);
        this.m_passProvider = bldr.realize(null, null, null);
    }

    @Injectable(value="password-url")
    public void setPasswordURL(ParameterizedBuilder<PasswordProvider> bldrPassProvider) {
        this.setPasswordProvider(bldrPassProvider);
    }

    @Injectable(value="password-provider")
    public void setPasswordProvider(ParameterizedBuilder<PasswordProvider> bldrPasswordProvider) {
        ParameterizedBuilder<PasswordProvider> bldr = bldrPasswordProvider == null ? PasswordProviderBuilderProcessor.getNullPasswordProviderBuilder() : bldrPasswordProvider;
        this.m_passProvider = bldr.realize(null, null, null);
    }

    @Injectable(value="algorithm")
    public void setAlgorithm(String sAlgorithm) {
        this.m_sAlgorithm = sAlgorithm;
    }

    @Injectable(value="key-store")
    public void setKeystore(KeystoreDependencies deps) {
        this.m_depsKeystore = deps == null ? KeystoreDependencies.NullImplementation : deps;
    }

    @Injectable(value="provider")
    public void setProviderBuilder(SSLSocketProviderDependenciesBuilder.ProviderBuilder m_bldrProvider) {
        this.m_bldrProvider = m_bldrProvider;
    }
}

