/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.xml.processor.PasswordProviderBuilderProcessor;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.ssl.KeystoreDependencies;
import com.tangosol.net.PasswordProvider;
import com.tangosol.net.ssl.KeyStoreLoader;

public class DefaultKeystoreDependencies
implements KeystoreDependencies {
    private PasswordProvider m_passProvider;
    private String m_sType = "PKCS12";
    private KeyStoreLoader m_keyStoreLoader;

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public KeyStoreLoader getKeyStoreLoader() {
        return this.m_keyStoreLoader;
    }

    @Override
    public PasswordProvider getPasswordProvider() {
        if (null == this.m_passProvider) {
            ParameterizedBuilder<PasswordProvider> builder = PasswordProviderBuilderProcessor.getNullPasswordProviderBuilder();
            this.m_passProvider = builder.realize(null, null, null);
        }
        return this.m_passProvider;
    }

    @Injectable(value="type")
    public void setType(String sType) {
        this.m_sType = sType;
    }

    @Injectable(value="password")
    public void setPassword(String sPassword) {
        ParameterizedBuilder<PasswordProvider> builder = PasswordProviderBuilderProcessor.getPasswordProviderBuilderForPasswordStr(sPassword);
        this.m_passProvider = builder.realize(null, null, null);
    }

    @Injectable(value="password-url")
    public void setPasswordURL(ParameterizedBuilder<PasswordProvider> builder) {
        this.setPasswordProvider(builder);
    }

    @Injectable(value="password-provider")
    public void setPasswordProvider(ParameterizedBuilder<PasswordProvider> builder) {
        this.m_passProvider = builder == null ? PasswordProvider.NullImplementation : builder.realize(null, null, null);
    }

    public void setKeyStoreLoader(KeyStoreLoader loader) {
        if (loader.isEnabled()) {
            this.m_keyStoreLoader = loader;
        }
    }

    public String toString() {
        return "keyStore=" + String.valueOf(this.m_keyStoreLoader);
    }
}

