/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.tangosol.coherence.config.builder.SSLSocketProviderDependenciesBuilder;
import com.tangosol.internal.net.ssl.AbstractManagerBuilder;
import com.tangosol.internal.net.ssl.KeyManagersBuilder;
import com.tangosol.internal.net.ssl.KeyStoreListener;
import com.tangosol.internal.net.ssl.KeystoreDependencies;
import com.tangosol.internal.net.ssl.ManagerDependencies;
import com.tangosol.net.PasswordProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

public class DefaultKeyManagerBuilder
extends AbstractManagerBuilder
implements KeyManagersBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyManager[] buildKeyManagers(ManagerDependencies deps, StringBuilder sb) throws GeneralSecurityException, IOException {
        KeyManager[] keyManagerArray;
        if (deps == null) {
            sb.append("identity=unspecified");
            return null;
        }
        char[] achPassword = null;
        try {
            KeyManagerFactory factory = this.createKeyManagerFactory(deps);
            PasswordProvider keyPasswordProvider = deps.getPrivateKeyPasswordProvider();
            KeystoreDependencies depsKeystore = deps.getKeystoreDependencies();
            List<KeyStoreListener> listeners = deps.getListeners();
            sb.append("identity=").append(deps.getAlgorithm()).append('/');
            char[] cArray = achPassword = keyPasswordProvider == null ? null : keyPasswordProvider.get();
            if (achPassword == null) {
                achPassword = new char[]{};
            }
            KeyStore keyStore = this.resolveKeystore(deps, depsKeystore, keyPasswordProvider, listeners, true, sb);
            factory.init(keyStore, achPassword);
            keyManagerArray = factory.getKeyManagers();
        }
        catch (Throwable throwable) {
            PasswordProvider.reset(new char[][]{achPassword});
            throw throwable;
        }
        PasswordProvider.reset(new char[][]{achPassword});
        return keyManagerArray;
    }

    @Override
    public boolean isRefreshable(ManagerDependencies deps) {
        KeystoreDependencies depsKeyStore = deps == null ? null : deps.getKeystoreDependencies();
        return this.shouldRefresh(deps, depsKeyStore);
    }

    protected KeyManagerFactory createKeyManagerFactory(ManagerDependencies deps) throws GeneralSecurityException {
        KeyManagerFactory factory = null;
        SSLSocketProviderDependenciesBuilder.ProviderBuilder providerBuilder = deps.getProviderBuilder();
        String sAlgorithm = deps.getAlgorithm();
        if (providerBuilder != null) {
            Provider provider = providerBuilder.realize(null, null, null);
            if (provider == null) {
                String sName = providerBuilder.getName();
                if (sName != null) {
                    factory = KeyManagerFactory.getInstance(sAlgorithm, sName);
                }
            } else {
                if (provider instanceof ManagerDependencies.Aware) {
                    ((ManagerDependencies.Aware)((Object)provider)).setDependencies(deps);
                }
                factory = KeyManagerFactory.getInstance(sAlgorithm, provider);
            }
        }
        if (factory == null) {
            factory = KeyManagerFactory.getInstance(sAlgorithm);
        }
        return factory;
    }
}

