/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.ssl;

import com.tangosol.internal.net.ssl.KeyStoreListener;
import com.tangosol.internal.net.ssl.KeystoreDependencies;
import com.tangosol.internal.net.ssl.ManagerDependencies;
import com.tangosol.net.PasswordProvider;
import com.tangosol.net.ssl.CertificateLoader;
import com.tangosol.net.ssl.EmptyKeyStoreLoader;
import com.tangosol.net.ssl.KeyStoreLoader;
import com.tangosol.net.ssl.PrivateKeyLoader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AbstractManagerBuilder {
    protected KeyStore resolveKeystore(ManagerDependencies depsManager, KeystoreDependencies depsKeyStore, PasswordProvider keyPasswordProvider, List<KeyStoreListener> listeners, boolean fIdentity, StringBuilder sbDescr) throws GeneralSecurityException, IOException {
        String sType = depsKeyStore.getType();
        KeyStoreLoader keyStoreLoader = depsKeyStore.getKeyStoreLoader();
        if (keyStoreLoader != null) {
            PasswordProvider passwordProvider = depsKeyStore.getPasswordProvider();
            KeyStore keyStore = keyStoreLoader.load(sType, passwordProvider);
            if (keyStore != null) {
                sbDescr.append(keyStoreLoader);
                this.onKeyStore(keyStore, passwordProvider, listeners, fIdentity);
                return keyStore;
            }
        } else {
            keyStoreLoader = EmptyKeyStoreLoader.INSTANCE;
        }
        PrivateKeyLoader privateKeyLoader = depsManager.getPrivateKeyLoader();
        Object[] aCertificateLoader = depsManager.getCertificateLoaders();
        Certificate[] aCertificate = null;
        boolean fComma = false;
        if (privateKeyLoader != null) {
            sbDescr.append("key=[").append(privateKeyLoader).append("]");
            fComma = true;
        }
        if (aCertificateLoader != null && aCertificateLoader.length > 0) {
            if (fComma) {
                sbDescr.append(", ");
            }
            sbDescr.append("certs=").append(Arrays.toString(aCertificateLoader));
        }
        if (aCertificateLoader != null && aCertificateLoader.length > 0) {
            ArrayList<Certificate> listCert = new ArrayList<Certificate>();
            for (Object loader : aCertificateLoader) {
                Certificate[] ac = loader.load();
                if (ac == null) continue;
                listCert.addAll(Arrays.asList(ac));
            }
            Certificate[] certificateArray = aCertificate = listCert.isEmpty() ? null : listCert.toArray(new Certificate[0]);
        }
        if (privateKeyLoader != null) {
            PrivateKey key = privateKeyLoader.load(keyPasswordProvider);
            KeyStore keyStore = keyStoreLoader.load(sType, PasswordProvider.NullImplementation, key, keyPasswordProvider, aCertificate);
            this.onIdentityStore(keyStore, key, keyPasswordProvider, aCertificate, listeners);
            return keyStore;
        }
        if (aCertificate != null) {
            KeyStore keyStore = keyStoreLoader.load(sType, PasswordProvider.NullImplementation, aCertificate);
            this.onCerts(keyStore, aCertificate, listeners, fIdentity);
            return keyStore;
        }
        return null;
    }

    protected boolean shouldRefresh(ManagerDependencies depsManager, KeystoreDependencies depsKeyStore) {
        KeyStoreLoader keyStoreLoader;
        if (depsManager == null) {
            return true;
        }
        KeyStoreLoader keyStoreLoader2 = keyStoreLoader = depsKeyStore == null ? null : depsKeyStore.getKeyStoreLoader();
        if (keyStoreLoader != null && keyStoreLoader.isRefreshable()) {
            return true;
        }
        PrivateKeyLoader privateKeyLoader = depsManager.getPrivateKeyLoader();
        if (privateKeyLoader != null && privateKeyLoader.isRefreshable()) {
            return true;
        }
        CertificateLoader[] aCertificateLoader = depsManager.getCertificateLoaders();
        if (aCertificateLoader != null) {
            return Arrays.stream(aCertificateLoader).anyMatch(CertificateLoader::isRefreshable);
        }
        return false;
    }

    protected void onKeyStore(KeyStore keyStore, PasswordProvider provider, List<KeyStoreListener> listeners, boolean fIdentity) {
        if (fIdentity) {
            listeners.forEach(l -> l.identityStoreLoaded(keyStore, provider));
        } else {
            listeners.forEach(l -> l.trustStoreLoaded(keyStore, provider));
        }
    }

    protected void onCerts(KeyStore keyStore, Certificate[] aCert, List<KeyStoreListener> listeners, boolean fIdentity) {
        if (fIdentity) {
            listeners.forEach(l -> l.identityStoreLoaded(null, null, aCert));
            listeners.forEach(l -> l.identityStoreLoaded(keyStore, PasswordProvider.NullImplementation));
        } else {
            listeners.forEach(l -> l.trustStoreLoaded(aCert));
            listeners.forEach(l -> l.trustStoreLoaded(keyStore, PasswordProvider.NullImplementation));
        }
    }

    protected void onIdentityStore(KeyStore keyStore, PrivateKey key, PasswordProvider keyProvider, Certificate[] aCert, List<KeyStoreListener> listeners) {
        listeners.forEach(l -> l.identityStoreLoaded(key, keyProvider, aCert));
        listeners.forEach(l -> l.identityStoreLoaded(keyStore, PasswordProvider.NullImplementation));
    }
}

