/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer.acceptor;

import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.internal.net.service.peer.acceptor.DefaultTcpAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.TcpAcceptorDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.util.Base;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DefaultNSTcpAcceptorDependencies
extends DefaultTcpAcceptorDependencies {
    public DefaultNSTcpAcceptorDependencies() {
        this(null);
        this.setMaxIncomingMessageSize(4096);
    }

    public DefaultNSTcpAcceptorDependencies(TcpAcceptorDependencies deps) {
        super(deps);
        if (deps == null || deps.getMaxIncomingMessageSize() == 0) {
            this.setMaxIncomingMessageSize(4096);
        }
    }

    @Override
    protected InetAddress getDefaultHost() {
        String sPropAddr = Config.getProperty("coherence.nameservice.address");
        if (sPropAddr != null) {
            try {
                return InetAddress.getByName(sPropAddr);
            }
            catch (UnknownHostException e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        return CacheFactory.getCluster().getDependencies().getLocalDiscoveryAddress();
    }

    @Override
    protected SocketProviderBuilder createDefaultSocketProviderBuilder() {
        return new SocketProviderBuilder(SocketProviderFactory.DEFAULT_SOCKET_PROVIDER, false);
    }

    @Override
    public boolean canUseGlobalSocketProvider() {
        return false;
    }
}

