/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer.acceptor;

import com.oracle.coherence.common.net.TcpSocketProvider;
import com.tangosol.application.Context;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.peer.acceptor.AbstractAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.net.grpc.GrpcAcceptorController;

public class DefaultGrpcAcceptorDependencies
extends AbstractAcceptorDependencies
implements GrpcAcceptorDependencies {
    private GrpcAcceptorController m_controller;
    private String m_sLocalAddress = this.normalizeAddress(null, 0);
    private int m_nLocalPort = 0;
    private SocketProviderBuilder m_builderSocketProvider = new SocketProviderBuilder(TcpSocketProvider.DEMULTIPLEXED, true);
    private String m_sInProcessName = "default";
    private int m_nChannelzPageSize;
    private Context m_context;

    public DefaultGrpcAcceptorDependencies() {
        this(null);
    }

    public DefaultGrpcAcceptorDependencies(GrpcAcceptorDependencies deps) {
        super(deps);
        if (deps != null) {
            this.setChannelzPageSize(deps.getChannelzPageSize());
            this.setContext(deps.getContext());
            this.setController(deps.getController());
            this.setInProcessName(deps.getInProcessName());
            this.setLocalAddress(deps.getLocalAddress());
            this.setLocalPort(deps.getLocalPort());
            this.setSocketProviderBuilder(deps.getSocketProviderBuilder());
        }
    }

    @Override
    public GrpcAcceptorController getController() {
        GrpcAcceptorController controller = this.m_controller;
        if (controller == null) {
            controller = this.m_controller = GrpcAcceptorController.discoverController();
        }
        return controller;
    }

    @Injectable(value="controller")
    public void setController(GrpcAcceptorController controller) {
        this.m_controller = controller;
    }

    @Override
    public SocketProviderBuilder getSocketProviderBuilder() {
        return this.m_builderSocketProvider;
    }

    @Injectable(value="socket-provider")
    public void setSocketProviderBuilder(SocketProviderBuilder builder) {
        this.m_builderSocketProvider = builder;
    }

    @Override
    public int getLocalPort() {
        return this.m_nLocalPort;
    }

    @Injectable(value="local-address/port")
    public void setLocalPort(int nPort) {
        this.m_nLocalPort = nPort;
    }

    @Override
    public String getLocalAddress() {
        return this.m_sLocalAddress;
    }

    @Injectable(value="local-address/address")
    public void setLocalAddress(String sAddress) {
        this.m_sLocalAddress = this.normalizeAddress(sAddress, this.getLocalPort());
    }

    @Override
    public String getInProcessName() {
        return this.m_sInProcessName;
    }

    @Injectable(value="in-process-name")
    public void setInProcessName(String sName) {
        this.m_sInProcessName = sName;
    }

    @Override
    public int getChannelzPageSize() {
        return this.m_nChannelzPageSize <= 0 ? 100 : this.m_nChannelzPageSize;
    }

    public void setChannelzPageSize(int nPageSize) {
        this.m_nChannelzPageSize = nPageSize;
    }

    @Injectable
    public void setContext(Context context) {
        this.m_context = context;
    }

    @Override
    public Context getContext() {
        return this.m_context;
    }
}

