/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.peer.acceptor;

import com.oracle.coherence.common.net.InetAddresses;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.peer.DefaultPeerDependencies;
import com.tangosol.internal.net.service.peer.acceptor.AcceptorDependencies;
import com.tangosol.util.Base;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class AbstractAcceptorDependencies
extends DefaultPeerDependencies
implements AcceptorDependencies {
    private int m_cConnectionLimit;

    public AbstractAcceptorDependencies() {
        this(null);
    }

    public AbstractAcceptorDependencies(AcceptorDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_cConnectionLimit = deps.getConnectionLimit();
        }
    }

    @Override
    public int getConnectionLimit() {
        return this.m_cConnectionLimit;
    }

    @Injectable(value="connection-limit")
    public void setConnectionLimit(int cLimit) {
        this.m_cConnectionLimit = cLimit;
    }

    @Override
    public AbstractAcceptorDependencies validate() {
        super.validate();
        Base.azzert(this.getConnectionLimit() >= 0, "Connection limit cannot be less than 0");
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "{ConnectionLimit=" + this.getConnectionLimit() + "}";
    }

    protected String normalizeAddress(String sAddress, int nPort) {
        block5: {
            try {
                if (sAddress == null || sAddress.isEmpty()) {
                    sAddress = InetAddresses.ADDR_ANY.getHostAddress();
                    break block5;
                }
                InetAddress addr = InetAddresses.getLocalAddress(sAddress);
                if (InetAddresses.isLocalAddress(addr)) {
                    sAddress = addr.getHostAddress();
                    break block5;
                }
                if (InetAddresses.isNatLocalAddress(addr, nPort)) {
                    sAddress = InetAddresses.ADDR_ANY.getHostAddress();
                    break block5;
                }
                throw new IllegalArgumentException(sAddress + " does not represent a local address");
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return sAddress;
    }
}

