/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.grid;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.grid.DefaultPartitionedServiceDependencies;
import com.tangosol.internal.net.service.grid.PartitionedCacheDependencies;
import com.tangosol.io.DecorationOnlyDeltaCompressor;
import com.tangosol.io.DeltaCompressor;
import com.tangosol.util.Base;

public class DefaultPartitionedCacheDependencies
extends DefaultPartitionedServiceDependencies
implements PartitionedCacheDependencies {
    private int m_cBackupAfterWriteBehind = -1;
    private DeltaCompressor m_deltaCompressor = null;
    private int m_nLeaseGranularity = 0;
    private long m_cStandardLeaseMillis = 0L;
    private boolean m_fStrictPartitioning = Config.getBoolean("coherence.distributed.strict", true);

    public DefaultPartitionedCacheDependencies() {
        this(null);
    }

    public DefaultPartitionedCacheDependencies(PartitionedCacheDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_cBackupAfterWriteBehind = deps.getBackupCountAfterWriteBehind();
            this.m_deltaCompressor = deps.getDeltaCompressor();
            this.m_nLeaseGranularity = deps.getLeaseGranularity();
            this.m_fStrictPartitioning = deps.isStrictPartitioning();
            this.m_cStandardLeaseMillis = deps.getStandardLeaseMillis();
        }
    }

    @Override
    public int getBackupCountAfterWriteBehind() {
        return this.m_cBackupAfterWriteBehind == -1 ? this.getPreferredBackupCount() : this.m_cBackupAfterWriteBehind;
    }

    @Injectable(value="backup-count-after-writebehind")
    public void setBackupCountAfterWriteBehind(int cBackups) {
        this.m_cBackupAfterWriteBehind = cBackups;
    }

    @Override
    public DeltaCompressor getDeltaCompressor() {
        return this.m_deltaCompressor == null ? new DecorationOnlyDeltaCompressor() : this.m_deltaCompressor;
    }

    @Injectable(value="compressor")
    public void setDeltaCompressor(DeltaCompressor compressor) {
        this.m_deltaCompressor = compressor;
    }

    @Override
    public boolean isStrictPartitioning() {
        return this.m_fStrictPartitioning;
    }

    public void setStrictPartitioning(boolean fStrict) {
        this.m_fStrictPartitioning = fStrict;
    }

    @Override
    public int getLeaseGranularity() {
        return this.m_nLeaseGranularity;
    }

    @Injectable(value="lease-granularity")
    public void setLeaseGranularity(int nGranularity) {
        this.m_nLeaseGranularity = nGranularity;
    }

    @Override
    public long getStandardLeaseMillis() {
        return this.m_cStandardLeaseMillis;
    }

    @Injectable(value="standard-lease-milliseconds")
    public void setStandardLeaseMillis(long cMillis) {
        this.m_cStandardLeaseMillis = cMillis;
    }

    @Override
    public DefaultPartitionedServiceDependencies validate() {
        super.validate();
        Base.checkRange(this.getStandardLeaseMillis(), 0L, Integer.MAX_VALUE, "StandardLeaseMillis");
        Base.checkRange(this.getLeaseGranularity(), 0L, Integer.MAX_VALUE, "LeaseGranularity");
        this.validateBackupCountAfterWriteBehind();
        return this;
    }

    protected void validateBackupCountAfterWriteBehind() {
        int cBackups = this.getPreferredBackupCount();
        int cBackupsOpt = this.getBackupCountAfterWriteBehind();
        if (cBackupsOpt != cBackups && cBackupsOpt > 0) {
            Logger.warn("Valid values for the <backup-count-after-writebehind> element are 0 or " + cBackups + " (the value from the <backup-count> element); defaulting to " + cBackups + " for the service.");
            this.setBackupCountAfterWriteBehind(cBackups);
        }
    }
}

