/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service.grid;

import com.tangosol.coherence.config.builder.ActionPolicyBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ServiceFailurePolicyBuilder;
import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.net.service.DefaultServiceDependencies;
import com.tangosol.internal.net.service.grid.GridDependencies;
import com.tangosol.net.MemberListener;
import com.tangosol.util.Base;
import java.util.List;

public class DefaultGridDependencies
extends DefaultServiceDependencies
implements GridDependencies {
    private ActionPolicyBuilder m_bldrActionPolicy = new ActionPolicyBuilder.NullImplementationBuilder();
    private long m_cGuardTimeoutMillis = -1L;
    private List<ParameterizedBuilder<MemberListener>> m_buildersMemberListener;
    private ServiceFailurePolicyBuilder m_bldrServiceFailurePolicy;
    private String m_sTransport;

    public DefaultGridDependencies() {
        this(null);
    }

    public DefaultGridDependencies(GridDependencies deps) {
        super(deps);
        if (deps != null) {
            this.m_bldrActionPolicy = deps.getActionPolicyBuilder();
            this.m_cGuardTimeoutMillis = deps.getDefaultGuardTimeoutMillis();
            this.m_buildersMemberListener = deps.getMemberListenerBuilders();
            this.m_bldrServiceFailurePolicy = deps.getServiceFailurePolicyBuilder();
            this.m_sTransport = deps.getReliableTransport();
        }
    }

    @Override
    public ActionPolicyBuilder getActionPolicyBuilder() {
        return this.m_bldrActionPolicy;
    }

    public void setActionPolicyBuilder(ActionPolicyBuilder builder) {
        this.m_bldrActionPolicy = builder;
    }

    @Override
    public long getDefaultGuardTimeoutMillis() {
        return this.m_cGuardTimeoutMillis;
    }

    @Injectable(value="guardian-timeout")
    public void setDefaultGuardTimeoutMillis(long cMillis) {
        this.m_cGuardTimeoutMillis = cMillis;
    }

    @Override
    public List<ParameterizedBuilder<MemberListener>> getMemberListenerBuilders() {
        return this.m_buildersMemberListener;
    }

    @Injectable(value="member-listener")
    public void setMemberListenerBuilders(List<ParameterizedBuilder<MemberListener>> listBuilder) {
        this.m_buildersMemberListener = listBuilder;
    }

    @Override
    public ServiceFailurePolicyBuilder getServiceFailurePolicyBuilder() {
        return this.m_bldrServiceFailurePolicy;
    }

    @Injectable(value="service-failure-policy")
    public void setServiceFailurePolicyBuilder(ServiceFailurePolicyBuilder builder) {
        this.m_bldrServiceFailurePolicy = builder;
    }

    @Override
    public String getReliableTransport() {
        return this.m_sTransport;
    }

    @Injectable(value="reliable-transport")
    public void setReliableTransport(String sTransport) {
        this.m_sTransport = sTransport;
    }

    @Override
    public String toString() {
        return super.toString() + "{ActionPolicyBuilder=" + String.valueOf(this.getActionPolicyBuilder()) + ", GuardianTimeout=" + this.getDefaultGuardTimeoutMillis() + ", MemberListenerBuilders=" + String.valueOf(this.getMemberListenerBuilders()) + ", ServiceFailurePolicyBuilder=" + String.valueOf(this.getServiceFailurePolicyBuilder()) + ", Transport=" + this.getReliableTransport() + "}";
    }

    @Override
    public DefaultGridDependencies validate() {
        super.validate();
        Base.azzert(this.getActionPolicyBuilder() != null, "ActionPolicyBuilder can not be null");
        this.validateGuardTimeout();
        return this;
    }

    protected void validateGuardTimeout() {
        long cTimeoutMillis = this.getDefaultGuardTimeoutMillis();
        if (cTimeoutMillis > 0L) {
            cTimeoutMillis = Math.max(cTimeoutMillis, 5000L);
        } else if (cTimeoutMillis == 0L) {
            this.setServiceFailurePolicyBuilder(new ServiceFailurePolicyBuilder(3));
        }
    }
}

