/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.service;

import com.tangosol.config.annotation.Injectable;
import com.tangosol.internal.health.HealthCheckDependencies;
import com.tangosol.internal.net.service.ServiceDependencies;
import com.tangosol.io.SerializerFactory;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;

public class DefaultServiceDependencies
implements ServiceDependencies {
    private int m_nEventDispatcherThreadPriority = 10;
    private long m_cRequestTimeoutMillis;
    private SerializerFactory m_serializerFactory;
    private long m_cTaskHungThresholdMillis;
    private long m_cTaskTimeoutMillis;
    private int m_nThreadPriority = 10;
    private int m_cWorkerThreads;
    private int m_cWorkerThreadsMax = Integer.MAX_VALUE;
    private int m_cWorkerThreadsMin;
    private int m_nWorkerPriority = 5;
    private boolean m_fDeprecatedThreadConfiguration;
    private boolean m_fThreadConfiguration;
    private HealthCheckDependencies m_healthCheckDependencies;

    public DefaultServiceDependencies() {
        this(null);
    }

    public DefaultServiceDependencies(com.tangosol.net.ServiceDependencies deps) {
        if (deps != null) {
            this.m_nEventDispatcherThreadPriority = deps.getEventDispatcherThreadPriority();
            this.m_cRequestTimeoutMillis = deps.getRequestTimeoutMillis();
            this.m_serializerFactory = deps.getSerializerFactory();
            this.m_cTaskHungThresholdMillis = deps.getTaskHungThresholdMillis();
            this.m_cTaskTimeoutMillis = deps.getTaskTimeoutMillis();
            this.m_nThreadPriority = deps.getThreadPriority();
            this.m_cWorkerThreads = deps.getWorkerThreadCount();
            this.m_cWorkerThreadsMax = deps.getWorkerThreadCountMax();
            this.m_cWorkerThreadsMin = deps.getWorkerThreadCountMin();
            this.m_nWorkerPriority = deps.getWorkerThreadPriority();
            this.m_healthCheckDependencies = deps.getHealthCheckDependencies();
            if (deps instanceof DefaultServiceDependencies) {
                DefaultServiceDependencies sDeps = (DefaultServiceDependencies)deps;
                this.m_fDeprecatedThreadConfiguration = sDeps.m_fDeprecatedThreadConfiguration;
                this.m_fThreadConfiguration = sDeps.m_fThreadConfiguration;
            }
        }
    }

    @Override
    public int getEventDispatcherThreadPriority() {
        return this.m_nEventDispatcherThreadPriority;
    }

    @Injectable(value="event-dispatcher-priority")
    public void setEventDispatcherThreadPriority(int nPriority) {
        this.m_nEventDispatcherThreadPriority = nPriority;
    }

    @Override
    public long getRequestTimeoutMillis() {
        return this.m_cRequestTimeoutMillis;
    }

    @Injectable(value="request-timeout")
    public void setRequestTimeoutMillis(long cMillis) {
        this.m_cRequestTimeoutMillis = cMillis;
    }

    @Override
    public SerializerFactory getSerializerFactory() {
        return this.m_serializerFactory;
    }

    @Injectable(value="serializer")
    public void setSerializerFactory(SerializerFactory factory) {
        this.m_serializerFactory = factory;
    }

    @Override
    public long getTaskHungThresholdMillis() {
        return this.m_cTaskHungThresholdMillis;
    }

    @Injectable(value="task-hung-threshold")
    public void setTaskHungThresholdMillis(long cMillis) {
        this.m_cTaskHungThresholdMillis = cMillis;
    }

    @Override
    public long getTaskTimeoutMillis() {
        return this.m_cTaskTimeoutMillis;
    }

    @Injectable(value="task-timeout")
    public void setTaskTimeoutMillis(long cMillis) {
        this.m_cTaskTimeoutMillis = cMillis;
    }

    @Override
    public int getThreadPriority() {
        return this.m_nThreadPriority;
    }

    @Injectable(value="service-priority")
    public void setThreadPriority(int nPriority) {
        this.m_nThreadPriority = nPriority;
    }

    @Override
    public int getWorkerThreadCount() {
        return this.m_cWorkerThreads;
    }

    @Injectable(value="thread-count")
    public void setWorkerThreadCount(int cThreads) {
        this.m_fDeprecatedThreadConfiguration = true;
        this.m_cWorkerThreads = cThreads;
    }

    @Override
    public int getWorkerThreadCountMax() {
        return this.m_cWorkerThreadsMax;
    }

    @Injectable(value="thread-count-max")
    public void setWorkerThreadCountMax(int cThreads) {
        this.m_fThreadConfiguration = true;
        this.m_cWorkerThreadsMax = cThreads;
    }

    @Override
    public int getWorkerThreadCountMin() {
        return this.m_cWorkerThreadsMin;
    }

    @Injectable(value="thread-count-min")
    public void setWorkerThreadCountMin(int cThreads) {
        this.m_fThreadConfiguration = true;
        this.m_cWorkerThreadsMin = cThreads;
    }

    @Override
    public int getWorkerThreadPriority() {
        return this.m_nWorkerPriority;
    }

    @Injectable(value="worker-priority")
    public void setWorkerThreadPriority(int nPriority) {
        this.m_nWorkerPriority = nPriority;
    }

    @Override
    public HealthCheckDependencies getHealthCheckDependencies() {
        return this.m_healthCheckDependencies;
    }

    @Injectable(value="health")
    public void setHealthCheckDependencies(HealthCheckDependencies deps) {
        this.m_healthCheckDependencies = deps;
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{EventDispatcherThreadPriority=" + this.getEventDispatcherThreadPriority() + ", RequestTimeoutMillis=" + this.getRequestTimeoutMillis() + ", SerializerFactory=" + String.valueOf(this.getSerializerFactory()) + ", TaskHungThresholdMillis=" + this.getTaskHungThresholdMillis() + ", TaskTimeoutMillis=" + this.getTaskTimeoutMillis() + ", ThreadPriority=" + this.getThreadPriority() + ", WorkerThreadCount=" + this.getWorkerThreadCount() + ", WorkerThreadCountMax=" + this.getWorkerThreadCountMax() + ", WorkerThreadCountMin=" + this.getWorkerThreadCountMin() + ", WorkerThreadPriority=" + this.getWorkerThreadPriority() + "}";
    }

    public DefaultServiceDependencies validate() {
        Base.azzert(this.getEventDispatcherThreadPriority() >= 1, "EventDispatcherThreadPriority cannot be less than 1");
        Base.azzert(this.getEventDispatcherThreadPriority() <= 10, "EventDispatcherThreadPriority cannot be more than 10");
        Base.azzert(this.getRequestTimeoutMillis() >= 0L, "RequestTimeout cannot be less than 0");
        Base.azzert(this.getTaskHungThresholdMillis() >= 0L, "TaskHungThreshold cannot be less than 0");
        Base.azzert(this.getTaskTimeoutMillis() >= 0L, "TaskTimeoutMillis cannot be less than 0");
        Base.azzert(this.getThreadPriority() >= 1, "ThreadPriority cannot be less than 1");
        Base.azzert(this.getThreadPriority() <= 10, "ThreadPriority cannot be more than 10");
        Base.azzert(this.getWorkerThreadPriority() >= 1, "WorkerThreadPriority cannot be less than 1");
        Base.azzert(this.getWorkerThreadPriority() <= 10, "WorkerThreadPriority cannot be more than 10");
        if (this.m_fDeprecatedThreadConfiguration) {
            int cThreadCount = this.getWorkerThreadCount();
            this.setWorkerThreadCountMin(cThreadCount);
            this.setWorkerThreadCountMax(cThreadCount);
        } else {
            int cWorkerMax;
            int cWorkerMin = this.getWorkerThreadCountMin();
            if (cWorkerMin > (cWorkerMax = this.getWorkerThreadCountMax())) {
                this.setWorkerThreadCountMax(cWorkerMin);
            }
        }
        Base.azzert(this.getWorkerThreadCountMax() >= this.getWorkerThreadCountMin(), "WorkerThreadCountMax value " + this.getWorkerThreadCountMax() + " must be greater than or equal to WorkerThreadCountMin value " + this.getWorkerThreadCountMin());
        if (this.getWorkerThreadCountMin() < 0) {
            Base.azzert(this.getWorkerThreadCountMax() == Integer.MAX_VALUE || this.getWorkerThreadCountMax() == -1, "Inconsistent WorkerThreadCountMax and WorkerThreadCountMin");
        }
        return this;
    }
}

