/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.security;

import com.tangosol.coherence.config.ParameterMacroExpressionParser;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.xml.OperationalConfigNamespaceHandler;
import com.tangosol.coherence.config.xml.processor.PasswordProviderBuilderProcessor;
import com.tangosol.config.xml.DefaultProcessingContext;
import com.tangosol.config.xml.DocumentProcessor;
import com.tangosol.internal.net.security.DefaultStandardDependencies;
import com.tangosol.internal.net.security.LegacyXmlSecurityHelper;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.PasswordProvider;
import com.tangosol.net.security.AccessController;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import java.util.Arrays;
import javax.security.auth.callback.CallbackHandler;

public class LegacyXmlStandardHelper {
    public static DefaultStandardDependencies fromXml(XmlElement xml, DefaultStandardDependencies deps) {
        LegacyXmlSecurityHelper.fromXml(xml, deps);
        if (deps.isEnabled()) {
            XmlElement xmlAC = xml.getSafeElement("access-controller");
            XmlElement xmlCH = xml.getSafeElement("callback-handler");
            AccessController controller = (AccessController)LegacyXmlStandardHelper.newInstance(xmlAC);
            if (controller == null) {
                throw new RuntimeException("The 'access-controller' configuration element must be specified");
            }
            CallbackHandler handler = (CallbackHandler)LegacyXmlStandardHelper.newInstance(xmlCH);
            deps.setAccessController(controller);
            deps.setCallbackHandler(handler);
            deps.setLoginModuleName(xml.getSafeElement("login-module-name").getString(deps.getLoginModuleName()));
        }
        return deps;
    }

    private static Object newInstance(XmlElement xmlConfig) {
        String sClass = xmlConfig.getSafeElement("class-name").getString();
        if (sClass.length() > 0) {
            XmlElement xmlParams = xmlConfig.getSafeElement("init-params");
            Object[] aoParam = XmlHelper.parseInitParams(xmlParams);
            XmlElement xmlPwdProvider = xmlConfig.getElement("password-provider");
            try {
                if (xmlPwdProvider != null) {
                    OperationalConfigNamespaceHandler nsHandler = new OperationalConfigNamespaceHandler();
                    DocumentProcessor.DefaultDependencies dependencies = new DocumentProcessor.DefaultDependencies(nsHandler).setExpressionParser(new ParameterMacroExpressionParser());
                    DefaultProcessingContext ctx = new DefaultProcessingContext(dependencies, null);
                    ctx.ensureNamespaceHandler("", nsHandler);
                    ParameterizedBuilder bldr = (ParameterizedBuilder)new PasswordProviderBuilderProcessor().process(ctx, xmlPwdProvider);
                    PasswordProvider pwdProvider = (PasswordProvider)bldr.realize(null, null, null);
                    int len = aoParam.length;
                    if (len < 4) {
                        aoParam = Arrays.copyOf(aoParam, len + 1);
                        aoParam[len] = pwdProvider;
                    } else {
                        String password;
                        if (aoParam[3] instanceof String && !(password = (String)aoParam[3]).isEmpty()) {
                            CacheFactory.log("Both a password parameter and a PasswordProvider are configured for the AccessController. The PasswordProvider will be used.", 2);
                        }
                        aoParam[3] = pwdProvider;
                    }
                }
                Class clz = ExternalizableHelper.loadClass(sClass, null, null);
                return ClassHelper.newInstance(clz, aoParam);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }
        return null;
    }
}

