/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.processor;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.internal.net.queue.processor.AbstractQueueProcessor;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteMap;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class QueueRemove<E>
extends AbstractQueueProcessor<QueueKey, E, Boolean> {
    public static final int IMPL_VERSION = 1;
    public static final int TARGET_FIRST = 1;
    public static final int TARGET_LAST = 2;
    public static final int TARGET_ALL = 3;
    private static final QueueRemove<?> INSTANCE_FIRST = new QueueRemove(1);
    private static final QueueRemove<?> INSTANCE_LAST = new QueueRemove(2);
    private static final QueueRemove<?> INSTANCE_ALL = new QueueRemove(3);
    @JsonbProperty(value="target")
    private int m_nTarget;

    public QueueRemove() {
    }

    private QueueRemove(int m_nTarget) {
        this.m_nTarget = m_nTarget;
    }

    @Override
    public Map<QueueKey, Boolean> processAll(Set<? extends InvocableMap.Entry<QueueKey, E>> setEntries) {
        LiteMap<QueueKey, Boolean> mapResult = new LiteMap<QueueKey, Boolean>();
        switch (this.m_nTarget) {
            case 1: 
            case 2: {
                TreeMap<QueueKey, InvocableMap.Entry<QueueKey, E>> sorted = new TreeMap<QueueKey, InvocableMap.Entry<QueueKey, E>>();
                for (InvocableMap.Entry<QueueKey, E> entry : setEntries) {
                    if (!entry.isPresent()) continue;
                    sorted.put(entry.getKey(), entry);
                }
                if (sorted.isEmpty()) break;
                QueueKey key = this.m_nTarget == 1 ? (QueueKey)sorted.firstKey() : (QueueKey)sorted.lastKey();
                ((InvocableMap.Entry)sorted.get(key)).remove(false);
                mapResult.put(key, true);
                break;
            }
            case 3: {
                QueueKey key = null;
                for (InvocableMap.Entry<QueueKey, E> entry : setEntries) {
                    if (!entry.isPresent()) continue;
                    key = entry.getKey();
                    entry.remove(false);
                }
                if (key == null) break;
                mapResult.put(key, true);
                break;
            }
            default: {
                Logger.warn("Entry processor " + this.getClass().getSimpleName() + " invoked with invalid target " + this.m_nTarget);
            }
        }
        return mapResult;
    }

    @Override
    public Boolean process(InvocableMap.Entry<QueueKey, E> entry) {
        if (entry.isPresent()) {
            entry.remove(false);
            return true;
        }
        return false;
    }

    @Override
    public int getImplVersion() {
        return 1;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nTarget = in.readInt(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nTarget);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nTarget = in.readInt();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_nTarget);
    }

    public static <E> QueueRemove<E> removeFirst() {
        return INSTANCE_FIRST;
    }

    public static <E> QueueRemove<E> removeLast() {
        return INSTANCE_LAST;
    }

    public static <E> QueueRemove<E> removeAll() {
        return INSTANCE_ALL;
    }
}

