/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.processor;

import com.tangosol.internal.net.queue.extractor.QueueKeyExtractor;
import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.internal.net.queue.model.QueuePageResult;
import com.tangosol.internal.net.queue.processor.AbstractQueueProcessor;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Converter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ObservableMap;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;

public class QueuePage<K extends QueueKey, E>
extends AbstractQueueProcessor<K, E, QueuePageResult>
implements EvolvablePortableObject,
ExternalizableLite {
    public static final int IMPL_VERSION = 1;
    @JsonbProperty(value="head")
    private boolean m_fHead;
    @JsonbProperty(value="size")
    private long m_nPageSize;
    @JsonbProperty(value="lastId")
    private long m_nLastId;
    @JsonbProperty(value="isPoll")
    private boolean m_fPoll;

    public QueuePage() {
    }

    public QueuePage(boolean fHead, long nPageSize, long nLastId, boolean fPoll) {
        this.m_fHead = fHead;
        this.m_nPageSize = nPageSize;
        this.m_nLastId = nLastId;
        this.m_fPoll = fPoll;
    }

    @Override
    public QueuePageResult process(InvocableMap.Entry<K, E> entry) {
        BinaryEntry<K, E> binaryEntry = entry.asBinaryEntry();
        QueueKeyExtractor.QueueIndex index = QueuePage.assertQueueIndex(binaryEntry);
        BackingMapContext context = binaryEntry.getBackingMapContext();
        ObservableMap backingMap = context.getBackingMap();
        BackingMapManagerContext bmContext = context.getManagerContext();
        Converter toBinary = bmContext.getValueToInternalConverter();
        Converter fromBinary = bmContext.getValueFromInternalConverter();
        ArrayList<Binary> listBinary = new ArrayList<Binary>();
        long count = 0L;
        long lastId = 0L;
        SortedMap<Long, Object> map = this.m_fHead ? index.tailMap(this.m_nLastId) : index.headMap(this.m_nLastId);
        for (Map.Entry<Long, Object> keyEntry : map.entrySet()) {
            if (count >= this.m_nPageSize) break;
            Object oKey = keyEntry.getValue();
            Binary binary = null;
            lastId = keyEntry.getKey();
            if (this.m_fPoll) {
                InvocableMap.Entry entryPoll = context.getBackingMapEntry(oKey);
                if (entryPoll.isPresent()) {
                    binary = entryPoll.asBinaryEntry().getBinaryValue();
                    entryPoll.remove(false);
                }
            } else {
                binary = (Binary)backingMap.get(oKey);
            }
            if (binary == null) continue;
            listBinary.add(binary);
            ++count;
        }
        return new QueuePageResult(lastId, listBinary);
    }

    @Override
    public int getImplVersion() {
        return 1;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_fHead = in.readBoolean(0);
        this.m_nLastId = in.readLong(1);
        this.m_nPageSize = in.readLong(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBoolean(0, this.m_fHead);
        out.writeLong(1, this.m_nLastId);
        out.writeLong(2, this.m_nPageSize);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_fHead = in.readBoolean();
        this.m_nLastId = in.readLong();
        this.m_nPageSize = in.readLong();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fHead);
        out.writeLong(this.m_nLastId);
        out.writeLong(this.m_nPageSize);
    }
}

